"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSloListActions = useSloListActions;
var _use_delete_slo = require("../../../hooks/slo/use_delete_slo");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSloListActions({
  slo,
  setIsAddRuleFlyoutOpen,
  setIsActionsPopoverOpen,
  setDeleteConfirmationModalOpen
}) {
  const {
    mutate: deleteSlo
  } = (0, _use_delete_slo.useDeleteSlo)();
  const handleDeleteConfirm = () => {
    setDeleteConfirmationModalOpen(false);
    deleteSlo({
      id: slo.id,
      name: slo.name
    });
  };
  const handleDeleteCancel = () => {
    setDeleteConfirmationModalOpen(false);
  };
  const handleCreateRule = () => {
    setIsActionsPopoverOpen(false);
    setIsAddRuleFlyoutOpen(true);
  };
  return {
    handleDeleteConfirm,
    handleDeleteCancel,
    handleCreateRule
  };
}