"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloListItem = SloListItem;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _slo_delete_confirmation_modal = require("../../../components/slo/delete_confirmation_modal/slo_delete_confirmation_modal");
var _use_slo_summary = require("../hooks/use_slo_summary");
var _burn_rate_rule_flyout = require("./common/burn_rate_rule_flyout");
var _use_slo_list_actions = require("../hooks/use_slo_list_actions");
var _slo_item_actions = require("./slo_item_actions");
var _slo_badges = require("./badges/slo_badges");
var _slo_summary = require("./slo_summary");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloListItem({
  slo,
  rules,
  historicalSummary = [],
  historicalSummaryLoading,
  activeAlerts
}) {
  const [isActionsPopoverOpen, setIsActionsPopoverOpen] = (0, _react.useState)(false);
  const [isAddRuleFlyoutOpen, setIsAddRuleFlyoutOpen] = (0, _react.useState)(false);
  const [isDeleteConfirmationModalOpen, setDeleteConfirmationModalOpen] = (0, _react.useState)(false);
  const {
    sloDetailsUrl
  } = (0, _use_slo_summary.useSloFormattedSummary)(slo);
  const {
    handleCreateRule,
    handleDeleteCancel,
    handleDeleteConfirm
  } = (0, _use_slo_list_actions.useSloListActions)({
    slo,
    setDeleteConfirmationModalOpen,
    setIsActionsPopoverOpen,
    setIsAddRuleFlyoutOpen
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "sloItem",
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, slo.summary ? /*#__PURE__*/_react.default.createElement("a", {
    "data-test-subj": "o11ySloListItemLink",
    href: sloDetailsUrl
  }, slo.name) : /*#__PURE__*/_react.default.createElement("span", null, slo.name))), /*#__PURE__*/_react.default.createElement(_slo_badges.SloBadges, {
    activeAlerts: activeAlerts,
    isLoading: !slo.summary,
    rules: rules,
    slo: slo,
    onClickRuleBadge: handleCreateRule
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, slo.summary ? /*#__PURE__*/_react.default.createElement(_slo_summary.SloSummary, {
    slo: slo,
    historicalSummary: historicalSummary,
    historicalSummaryLoading: historicalSummaryLoading
  }) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_slo_item_actions.SloItemActions, {
    slo: slo,
    isActionsPopoverOpen: isActionsPopoverOpen,
    setIsAddRuleFlyoutOpen: setIsAddRuleFlyoutOpen,
    setIsActionsPopoverOpen: setIsActionsPopoverOpen,
    setDeleteConfirmationModalOpen: setDeleteConfirmationModalOpen
  }))), /*#__PURE__*/_react.default.createElement(_burn_rate_rule_flyout.BurnRateRuleFlyout, {
    slo: slo,
    isAddRuleFlyoutOpen: isAddRuleFlyoutOpen,
    setIsAddRuleFlyoutOpen: setIsAddRuleFlyoutOpen
  }), isDeleteConfirmationModalOpen ? /*#__PURE__*/_react.default.createElement(_slo_delete_confirmation_modal.SloDeleteConfirmationModal, {
    slo: slo,
    onCancel: handleDeleteCancel,
    onConfirm: handleDeleteConfirm
  }) : null);
}