"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloListCardView = SloListCardView;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _sloSchema = require("@kbn/slo-schema");
var _use_fetch_historical_summary = require("../../../../hooks/slo/use_fetch_historical_summary");
var _slo_card_item = require("./slo_card_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useColumns = cardsPerRow => {
  var _ref;
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const isMedium = (0, _eui.useIsWithinBreakpoints)(['m']);
  const isLarge = (0, _eui.useIsWithinBreakpoints)(['l']);
  const columns = (_ref = Number(cardsPerRow)) !== null && _ref !== void 0 ? _ref : 3;
  switch (true) {
    case isMobile:
      return 1;
    case isMedium:
      return columns > 2 ? 2 : columns;
    case isLarge:
      return columns > 3 ? 3 : columns;
    default:
      return columns;
  }
};
function SloListCardView({
  sloList,
  loading,
  error,
  cardsPerRow,
  rulesBySlo,
  activeAlertsBySlo
}) {
  const {
    isLoading: historicalSummaryLoading,
    data: historicalSummaries = []
  } = (0, _use_fetch_historical_summary.useFetchHistoricalSummary)({
    list: sloList.map(slo => {
      var _slo$instanceId;
      return {
        sloId: slo.id,
        instanceId: (_slo$instanceId = slo.instanceId) !== null && _slo$instanceId !== void 0 ? _slo$instanceId : _sloSchema.ALL_VALUE
      };
    })
  });
  const columns = useColumns(cardsPerRow);
  if (loading && sloList.length === 0) {
    return /*#__PURE__*/_react.default.createElement(LoadingSloGrid, {
      gridSize: Number(cardsPerRow)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: columns,
    gutterSize: "m"
  }, sloList.filter(slo => slo.summary).map(slo => {
    var _slo$instanceId2, _historicalSummaries$;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `${slo.id}-${(_slo$instanceId2 = slo.instanceId) !== null && _slo$instanceId2 !== void 0 ? _slo$instanceId2 : 'ALL_VALUE'}`
    }, /*#__PURE__*/_react.default.createElement(_slo_card_item.SloCardItem, {
      slo: slo,
      loading: loading,
      error: error,
      activeAlerts: activeAlertsBySlo.get(slo),
      rules: rulesBySlo === null || rulesBySlo === void 0 ? void 0 : rulesBySlo[slo.id],
      historicalSummary: (_historicalSummaries$ = historicalSummaries.find(historicalSummary => {
        var _slo$instanceId3;
        return historicalSummary.sloId === slo.id && historicalSummary.instanceId === ((_slo$instanceId3 = slo.instanceId) !== null && _slo$instanceId3 !== void 0 ? _slo$instanceId3 : _sloSchema.ALL_VALUE);
      })) === null || _historicalSummaries$ === void 0 ? void 0 : _historicalSummaries$.data,
      historicalSummaryLoading: historicalSummaryLoading,
      cardsPerRow: Number(cardsPerRow)
    }));
  }));
}
function LoadingSloGrid({
  gridSize
}) {
  const ROWS = 4;
  const COLUMNS = gridSize;
  const loaders = Array(ROWS * COLUMNS).fill(null);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "m",
    columns: COLUMNS
  }, loaders.map((_, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: i
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    style: {
      height: '200px'
    },
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 2
  })), ' '))));
}