"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformCreateSLOFormToCreateSLOInput = transformCreateSLOFormToCreateSLOInput;
exports.transformPartialUrlStateToFormState = transformPartialUrlStateToFormState;
exports.transformSloResponseToCreateSloForm = transformSloResponseToCreateSloForm;
exports.transformValuesToUpdateSLOInput = transformValuesToUpdateSLOInput;
var _std = require("@kbn/std");
var _lodash = require("lodash");
var _duration = require("../../../utils/slo/duration");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function transformSloResponseToCreateSloForm(values) {
  if (!values) return undefined;
  return {
    name: values.name,
    description: values.description,
    indicator: values.indicator,
    budgetingMethod: values.budgetingMethod,
    timeWindow: {
      duration: values.timeWindow.duration,
      type: values.timeWindow.type
    },
    objective: {
      target: values.objective.target * 100,
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceTarget && {
        timesliceTarget: values.objective.timesliceTarget * 100
      }),
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceWindow && {
        timesliceWindow: String((0, _duration.toDuration)(values.objective.timesliceWindow).value)
      })
    },
    groupBy: values.groupBy,
    tags: values.tags
  };
}
function transformCreateSLOFormToCreateSLOInput(values) {
  return {
    name: values.name,
    description: values.description,
    indicator: values.indicator,
    budgetingMethod: values.budgetingMethod,
    timeWindow: {
      duration: values.timeWindow.duration,
      type: values.timeWindow.type
    },
    objective: {
      target: values.objective.target / 100,
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceTarget && {
        timesliceTarget: values.objective.timesliceTarget / 100
      }),
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceWindow && {
        timesliceWindow: `${values.objective.timesliceWindow}m`
      })
    },
    tags: values.tags,
    groupBy: values.groupBy
  };
}
function transformValuesToUpdateSLOInput(values) {
  return {
    name: values.name,
    description: values.description,
    indicator: values.indicator,
    budgetingMethod: values.budgetingMethod,
    timeWindow: {
      duration: values.timeWindow.duration,
      type: values.timeWindow.type
    },
    objective: {
      target: values.objective.target / 100,
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceTarget && {
        timesliceTarget: values.objective.timesliceTarget / 100
      }),
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceWindow && {
        timesliceWindow: `${values.objective.timesliceWindow}m`
      })
    },
    tags: values.tags,
    groupBy: values.groupBy
  };
}
function transformPartialIndicatorState(indicator) {
  var _indicator$params, _indicator$params2, _indicator$params3, _indicator$params4, _indicator$params5, _indicator$params6;
  if (indicator === undefined || indicator.type === undefined) return undefined;
  const indicatorType = indicator.type;
  switch (indicatorType) {
    case 'sli.apm.transactionDuration':
      return {
        type: 'sli.apm.transactionDuration',
        params: Object.assign({}, _constants.APM_LATENCY_DEFAULT_VALUES.params, (_indicator$params = indicator.params) !== null && _indicator$params !== void 0 ? _indicator$params : {})
      };
    case 'sli.apm.transactionErrorRate':
      return {
        type: 'sli.apm.transactionErrorRate',
        params: Object.assign({}, _constants.APM_AVAILABILITY_DEFAULT_VALUES.params, (_indicator$params2 = indicator.params) !== null && _indicator$params2 !== void 0 ? _indicator$params2 : {})
      };
    case 'sli.histogram.custom':
      return {
        type: 'sli.histogram.custom',
        params: Object.assign({}, _constants.HISTOGRAM_DEFAULT_VALUES.params, (_indicator$params3 = indicator.params) !== null && _indicator$params3 !== void 0 ? _indicator$params3 : {})
      };
    case 'sli.kql.custom':
      return {
        type: 'sli.kql.custom',
        params: Object.assign({}, _constants.CUSTOM_KQL_DEFAULT_VALUES.params, (_indicator$params4 = indicator.params) !== null && _indicator$params4 !== void 0 ? _indicator$params4 : {})
      };
    case 'sli.metric.custom':
      return {
        type: 'sli.metric.custom',
        params: Object.assign({}, _constants.CUSTOM_METRIC_DEFAULT_VALUES.params, (_indicator$params5 = indicator.params) !== null && _indicator$params5 !== void 0 ? _indicator$params5 : {})
      };
    case 'sli.metric.timeslice':
      return {
        type: 'sli.metric.timeslice',
        params: Object.assign({}, _constants.TIMESLICE_METRIC_DEFAULT_VALUES.params, (_indicator$params6 = indicator.params) !== null && _indicator$params6 !== void 0 ? _indicator$params6 : {})
      };
    default:
      (0, _std.assertNever)(indicatorType);
  }
}
function transformPartialUrlStateToFormState(values) {
  var _values$timeWindow, _values$timeWindow2;
  const state = (0, _lodash.cloneDeep)(_constants.SLO_EDIT_FORM_DEFAULT_VALUES);
  const indicator = transformPartialIndicatorState(values.indicator);
  if (indicator !== undefined) {
    state.indicator = indicator;
  }
  if (values.name) {
    state.name = values.name;
  }
  if (values.description) {
    state.description = values.description;
  }
  if (!!values.tags) {
    state.tags = values.tags;
  }
  if (values.objective) {
    if (values.objective.target) {
      state.objective = {
        target: values.objective.target * 100
      };
      if (values.objective.timesliceTarget && values.objective.timesliceWindow) {
        state.objective.timesliceTarget = values.objective.timesliceTarget * 100;
        state.objective.timesliceWindow = String((0, _duration.toDuration)(values.objective.timesliceWindow).value);
      }
    }
  }
  if (values.budgetingMethod) {
    state.budgetingMethod = values.budgetingMethod;
  }
  if (values.groupBy) {
    state.groupBy = values.groupBy;
  }
  if ((_values$timeWindow = values.timeWindow) !== null && _values$timeWindow !== void 0 && _values$timeWindow.duration && (_values$timeWindow2 = values.timeWindow) !== null && _values$timeWindow2 !== void 0 && _values$timeWindow2.type) {
    state.timeWindow = {
      duration: values.timeWindow.duration,
      type: values.timeWindow.type
    };
  }
  return state;
}