"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIMEWINDOW_TYPE_OPTIONS = exports.TIMESLICE_METRIC_DEFAULT_VALUES = exports.SLO_EDIT_FORM_DEFAULT_VALUES_CUSTOM_METRIC = exports.SLO_EDIT_FORM_DEFAULT_VALUES = exports.SLI_OPTIONS = exports.ROLLING_TIMEWINDOW_OPTIONS = exports.HISTOGRAM_DEFAULT_VALUES = exports.CUSTOM_METRIC_DEFAULT_VALUES = exports.CUSTOM_KQL_DEFAULT_VALUES = exports.COMPARATOR_OPTIONS = exports.COMPARATOR_MAPPING = exports.COMPARATOR_LTE = exports.COMPARATOR_LT = exports.COMPARATOR_GTE = exports.COMPARATOR_GT = exports.CALENDARALIGNED_TIMEWINDOW_OPTIONS = exports.BUDGETING_METHOD_OPTIONS = exports.APM_LATENCY_DEFAULT_VALUES = exports.APM_AVAILABILITY_DEFAULT_VALUES = void 0;
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _labels = require("../../utils/slo/labels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SLI_OPTIONS = [{
  value: 'sli.kql.custom',
  text: _labels.INDICATOR_CUSTOM_KQL
}, {
  value: 'sli.metric.custom',
  text: _labels.INDICATOR_CUSTOM_METRIC
}, {
  value: 'sli.metric.timeslice',
  text: _labels.INDICATOR_TIMESLICE_METRIC
}, {
  value: 'sli.histogram.custom',
  text: _labels.INDICATOR_HISTOGRAM
}, {
  value: 'sli.apm.transactionDuration',
  text: _labels.INDICATOR_APM_LATENCY
}, {
  value: 'sli.apm.transactionErrorRate',
  text: _labels.INDICATOR_APM_AVAILABILITY
}];
exports.SLI_OPTIONS = SLI_OPTIONS;
const BUDGETING_METHOD_OPTIONS = [{
  value: 'occurrences',
  text: _labels.BUDGETING_METHOD_OCCURRENCES
}, {
  value: 'timeslices',
  text: _labels.BUDGETING_METHOD_TIMESLICES
}];
exports.BUDGETING_METHOD_OPTIONS = BUDGETING_METHOD_OPTIONS;
const TIMEWINDOW_TYPE_OPTIONS = [{
  value: 'rolling',
  text: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timeWindow.rolling', {
    defaultMessage: 'Rolling'
  })
}, {
  value: 'calendarAligned',
  text: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timeWindow.calendarAligned', {
    defaultMessage: 'Calendar aligned'
  })
}];
exports.TIMEWINDOW_TYPE_OPTIONS = TIMEWINDOW_TYPE_OPTIONS;
const CALENDARALIGNED_TIMEWINDOW_OPTIONS = [{
  value: '1w',
  text: _i18n.i18n.translate('xpack.observability.slo.sloEdit.calendarTimeWindow.weekly', {
    defaultMessage: 'Weekly'
  })
}, {
  value: '1M',
  text: _i18n.i18n.translate('xpack.observability.slo.sloEdit.calendarTimeWindow.monthly', {
    defaultMessage: 'Monthly'
  })
}];
exports.CALENDARALIGNED_TIMEWINDOW_OPTIONS = CALENDARALIGNED_TIMEWINDOW_OPTIONS;
const ROLLING_TIMEWINDOW_OPTIONS = [90, 30, 7].map(number => ({
  value: `${number}d`,
  text: _i18n.i18n.translate('xpack.observability.slo.sloEdit.rollingTimeWindow.days', {
    defaultMessage: '{number} days',
    values: {
      number
    }
  })
}));
exports.ROLLING_TIMEWINDOW_OPTIONS = ROLLING_TIMEWINDOW_OPTIONS;
const CUSTOM_KQL_DEFAULT_VALUES = {
  type: 'sli.kql.custom',
  params: {
    index: '',
    filter: '',
    good: '',
    total: '',
    timestampField: ''
  }
};
exports.CUSTOM_KQL_DEFAULT_VALUES = CUSTOM_KQL_DEFAULT_VALUES;
const CUSTOM_METRIC_DEFAULT_VALUES = {
  type: 'sli.metric.custom',
  params: {
    index: '',
    filter: '',
    good: {
      metrics: [{
        name: 'A',
        aggregation: 'sum',
        field: ''
      }],
      equation: 'A'
    },
    total: {
      metrics: [{
        name: 'A',
        aggregation: 'sum',
        field: ''
      }],
      equation: 'A'
    },
    timestampField: ''
  }
};
exports.CUSTOM_METRIC_DEFAULT_VALUES = CUSTOM_METRIC_DEFAULT_VALUES;
const TIMESLICE_METRIC_DEFAULT_VALUES = {
  type: 'sli.metric.timeslice',
  params: {
    index: '',
    filter: '',
    metric: {
      metrics: [{
        name: 'A',
        aggregation: 'avg',
        field: ''
      }],
      equation: 'A',
      comparator: 'GT',
      threshold: 0
    },
    timestampField: ''
  }
};
exports.TIMESLICE_METRIC_DEFAULT_VALUES = TIMESLICE_METRIC_DEFAULT_VALUES;
const HISTOGRAM_DEFAULT_VALUES = {
  type: 'sli.histogram.custom',
  params: {
    index: '',
    timestampField: '',
    filter: '',
    good: {
      field: '',
      aggregation: 'value_count'
    },
    total: {
      field: '',
      aggregation: 'value_count'
    }
  }
};
exports.HISTOGRAM_DEFAULT_VALUES = HISTOGRAM_DEFAULT_VALUES;
const APM_LATENCY_DEFAULT_VALUES = {
  type: 'sli.apm.transactionDuration',
  params: {
    service: '',
    environment: '',
    transactionType: '',
    transactionName: '',
    threshold: 250,
    filter: '',
    index: ''
  }
};
exports.APM_LATENCY_DEFAULT_VALUES = APM_LATENCY_DEFAULT_VALUES;
const APM_AVAILABILITY_DEFAULT_VALUES = {
  type: 'sli.apm.transactionErrorRate',
  params: {
    service: '',
    environment: '',
    transactionType: '',
    transactionName: '',
    filter: '',
    index: ''
  }
};
exports.APM_AVAILABILITY_DEFAULT_VALUES = APM_AVAILABILITY_DEFAULT_VALUES;
const SLO_EDIT_FORM_DEFAULT_VALUES = {
  name: '',
  description: '',
  indicator: CUSTOM_KQL_DEFAULT_VALUES,
  timeWindow: {
    duration: ROLLING_TIMEWINDOW_OPTIONS[1].value,
    type: 'rolling'
  },
  tags: [],
  budgetingMethod: BUDGETING_METHOD_OPTIONS[0].value,
  objective: {
    target: 99
  },
  groupBy: _sloSchema.ALL_VALUE
};
exports.SLO_EDIT_FORM_DEFAULT_VALUES = SLO_EDIT_FORM_DEFAULT_VALUES;
const SLO_EDIT_FORM_DEFAULT_VALUES_CUSTOM_METRIC = {
  name: '',
  description: '',
  indicator: CUSTOM_METRIC_DEFAULT_VALUES,
  timeWindow: {
    duration: ROLLING_TIMEWINDOW_OPTIONS[1].value,
    type: 'rolling'
  },
  tags: [],
  budgetingMethod: BUDGETING_METHOD_OPTIONS[0].value,
  objective: {
    target: 99
  },
  groupBy: _sloSchema.ALL_VALUE
};
exports.SLO_EDIT_FORM_DEFAULT_VALUES_CUSTOM_METRIC = SLO_EDIT_FORM_DEFAULT_VALUES_CUSTOM_METRIC;
const COMPARATOR_GT = _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.timesliceMetric.gtLabel', {
  defaultMessage: 'Greater than'
});
exports.COMPARATOR_GT = COMPARATOR_GT;
const COMPARATOR_GTE = _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.timesliceMetric.gteLabel', {
  defaultMessage: 'Greater than or equal to'
});
exports.COMPARATOR_GTE = COMPARATOR_GTE;
const COMPARATOR_LT = _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.timesliceMetric.ltLabel', {
  defaultMessage: 'Less than'
});
exports.COMPARATOR_LT = COMPARATOR_LT;
const COMPARATOR_LTE = _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.timesliceMetric.lteLabel', {
  defaultMessage: 'Less than or equal to'
});
exports.COMPARATOR_LTE = COMPARATOR_LTE;
const COMPARATOR_MAPPING = {
  GT: COMPARATOR_GT,
  GTE: COMPARATOR_GTE,
  LT: COMPARATOR_LT,
  LTE: COMPARATOR_LTE
};
exports.COMPARATOR_MAPPING = COMPARATOR_MAPPING;
const COMPARATOR_OPTIONS = [{
  text: COMPARATOR_GT,
  value: 'GT'
}, {
  text: COMPARATOR_GTE,
  value: 'GTE'
}, {
  text: COMPARATOR_LT,
  value: 'LT'
}, {
  text: COMPARATOR_LTE,
  value: 'LTE'
}];
exports.COMPARATOR_OPTIONS = COMPARATOR_OPTIONS;