"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEditForm = SloEditForm;
exports.maxWidth = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _burn_rate_rule_flyout = require("../../slos/components/common/burn_rate_rule_flyout");
var _paths = require("../../../../common/locators/paths");
var _use_create_slo = require("../../../hooks/slo/use_create_slo");
var _use_fetch_rules_for_slo = require("../../../hooks/slo/use_fetch_rules_for_slo");
var _use_update_slo = require("../../../hooks/slo/use_update_slo");
var _kibana_react = require("../../../utils/kibana_react");
var _constants = require("../constants");
var _process_slo_form_values = require("../helpers/process_slo_form_values");
var _use_add_rule_flyout_state = require("../hooks/use_add_rule_flyout_state");
var _use_copy_to_json = require("../hooks/use_copy_to_json");
var _use_parse_url_state = require("../hooks/use_parse_url_state");
var _use_section_form_validation = require("../hooks/use_section_form_validation");
var _use_show_sections = require("../hooks/use_show_sections");
var _slo_edit_form_description_section = require("./slo_edit_form_description_section");
var _slo_edit_form_indicator_section = require("./slo_edit_form_indicator_section");
var _slo_edit_form_objective_section = require("./slo_edit_form_objective_section");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const maxWidth = 775;
exports.maxWidth = maxWidth;
function SloEditForm({
  slo
}) {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  const isEditMode = slo !== undefined;
  const {
    data: rules,
    isInitialLoading
  } = (0, _use_fetch_rules_for_slo.useFetchRulesForSlo)({
    sloIds: slo !== null && slo !== void 0 && slo.id ? [slo.id] : undefined
  });
  const sloFormValuesFromUrlState = (0, _use_parse_url_state.useParseUrlState)();
  const sloFormValuesFromSloResponse = (0, _process_slo_form_values.transformSloResponseToCreateSloForm)(slo);
  const isAddRuleFlyoutOpen = (0, _use_add_rule_flyout_state.useAddRuleFlyoutState)(isEditMode);
  const [isCreateRuleCheckboxChecked, setIsCreateRuleCheckboxChecked] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    if (isEditMode && rules && rules[slo.id].length) {
      setIsCreateRuleCheckboxChecked(false);
    }
  }, [isEditMode, rules, slo]);
  const methods = (0, _reactHookForm.useForm)({
    defaultValues: _constants.SLO_EDIT_FORM_DEFAULT_VALUES,
    values: sloFormValuesFromUrlState ? sloFormValuesFromUrlState : sloFormValuesFromSloResponse,
    mode: 'all'
  });
  const {
    watch,
    getFieldState,
    getValues,
    formState,
    trigger
  } = methods;
  const handleCopyToJson = (0, _use_copy_to_json.useCopyToJson)({
    trigger,
    getValues
  });
  const {
    isIndicatorSectionValid,
    isObjectiveSectionValid,
    isDescriptionSectionValid
  } = (0, _use_section_form_validation.useSectionFormValidation)({
    getFieldState,
    getValues,
    formState,
    watch
  });
  const {
    showDescriptionSection,
    showObjectiveSection
  } = (0, _use_show_sections.useShowSections)(isEditMode, formState.isValidating, isIndicatorSectionValid, isObjectiveSectionValid);
  const {
    mutateAsync: createSlo,
    isLoading: isCreateSloLoading
  } = (0, _use_create_slo.useCreateSlo)();
  const {
    mutateAsync: updateSlo,
    isLoading: isUpdateSloLoading
  } = (0, _use_update_slo.useUpdateSlo)();
  const handleSubmit = async () => {
    const isValid = await trigger();
    if (!isValid) {
      return;
    }
    const values = getValues();
    if (isEditMode) {
      const processedValues = (0, _process_slo_form_values.transformValuesToUpdateSLOInput)(values);
      if (isCreateRuleCheckboxChecked) {
        await updateSlo({
          sloId: slo.id,
          slo: processedValues
        });
        navigate(basePath.prepend(`${_paths.paths.observability.sloEdit(slo.id)}?${_use_add_rule_flyout_state.CREATE_RULE_SEARCH_PARAM}=true`));
      } else {
        updateSlo({
          sloId: slo.id,
          slo: processedValues
        });
        navigate(basePath.prepend(_paths.paths.observability.slos));
      }
    } else {
      const processedValues = (0, _process_slo_form_values.transformCreateSLOFormToCreateSLOInput)(values);
      if (isCreateRuleCheckboxChecked) {
        const {
          id
        } = await createSlo({
          slo: processedValues
        });
        navigate(basePath.prepend(`${_paths.paths.observability.sloEdit(id)}?${_use_add_rule_flyout_state.CREATE_RULE_SEARCH_PARAM}=true`));
      } else {
        createSlo({
          slo: processedValues
        });
        navigate(basePath.prepend(_paths.paths.observability.slos));
      }
    }
  };
  const navigate = (0, _react.useCallback)(url => setTimeout(() => navigateToUrl(url)), [navigateToUrl]);
  const handleChangeCheckbox = () => {
    setIsCreateRuleCheckboxChecked(!isCreateRuleCheckboxChecked);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, methods, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "sloForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      title: _i18n.i18n.translate('xpack.observability.slo.sloEdit.definition.title', {
        defaultMessage: 'Define SLI'
      }),
      children: /*#__PURE__*/_react.default.createElement(_slo_edit_form_indicator_section.SloEditFormIndicatorSection, {
        isEditMode: isEditMode
      }),
      status: isIndicatorSectionValid ? 'complete' : 'incomplete'
    }, {
      title: _i18n.i18n.translate('xpack.observability.slo.sloEdit.objectives.title', {
        defaultMessage: 'Set objectives'
      }),
      children: showObjectiveSection ? /*#__PURE__*/_react.default.createElement(_slo_edit_form_objective_section.SloEditFormObjectiveSection, null) : null,
      status: showObjectiveSection && isObjectiveSectionValid ? 'complete' : 'incomplete'
    }, {
      title: _i18n.i18n.translate('xpack.observability.slo.sloEdit.description.title', {
        defaultMessage: 'Describe SLO'
      }),
      children: showDescriptionSection ? /*#__PURE__*/_react.default.createElement(_slo_edit_form_description_section.SloEditFormDescriptionSection, null) : null,
      status: showDescriptionSection && isDescriptionSectionValid ? 'complete' : 'incomplete'
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "createNewRuleCheckbox",
    checked: isCreateRuleCheckboxChecked,
    disabled: isInitialLoading,
    "data-test-subj": "createNewRuleCheckbox",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.observability.slo.sloEdit.createAlert.title', {
      defaultMessage: 'Create an'
    }), ' ', /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.observability.slo.sloEdit.createAlert.ruleName', {
      defaultMessage: 'SLO burn rate alert rule'
    }))), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: 'Selecting this will allow you to create a new alert rule for this SLO upon saving.',
      position: "top"
    })),
    onChange: handleChangeCheckbox
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-test-subj": "sloFormSubmitButton",
    fill: true,
    isLoading: isCreateSloLoading || isUpdateSloLoading,
    onClick: handleSubmit
  }, isEditMode ? _i18n.i18n.translate('xpack.observability.slo.sloEdit.editSloButton', {
    defaultMessage: 'Update SLO'
  }) : _i18n.i18n.translate('xpack.observability.slo.sloEdit.createSloButton', {
    defaultMessage: 'Create SLO'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    "data-test-subj": "sloFormCancelButton",
    disabled: isCreateSloLoading || isUpdateSloLoading,
    onClick: () => navigateToUrl(basePath.prepend(_paths.paths.observability.slos))
  }, _i18n.i18n.translate('xpack.observability.slo.sloEdit.cancelButton', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    iconType: "copyClipboard",
    "data-test-subj": "sloFormCopyJsonButton",
    disabled: isCreateSloLoading || isUpdateSloLoading,
    onClick: handleCopyToJson
  }, _i18n.i18n.translate('xpack.observability.slo.sloEdit.copyJsonButton', {
    defaultMessage: 'Copy JSON'
  }))))), /*#__PURE__*/_react.default.createElement(_burn_rate_rule_flyout.BurnRateRuleFlyout, {
    slo: slo,
    isAddRuleFlyoutOpen: isAddRuleFlyoutOpen,
    canChangeTrigger: false
  }));
}