"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INSTANCE_SEARCH_PARAM = void 0;
exports.useGetInstanceIdQueryParam = useGetInstanceIdQueryParam;
var _sloSchema = require("@kbn/slo-schema");
var _reactRouterDom = require("react-router-dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INSTANCE_SEARCH_PARAM = 'instanceId';
exports.INSTANCE_SEARCH_PARAM = INSTANCE_SEARCH_PARAM;
function useGetInstanceIdQueryParam() {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const searchParams = new URLSearchParams(search);
  const instanceId = searchParams.get(INSTANCE_SEARCH_PARAM);
  return !!instanceId && instanceId !== _sloSchema.ALL_VALUE ? instanceId : undefined;
}