"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityStatusProgress = ObservabilityStatusProgress;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/observability-shared-plugin/public");
var _use_guided_setup_progress = require("../../../../hooks/use_guided_setup_progress");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ObservabilityStatusProgress({
  onViewDetailsClick,
  onDismissClick
}) {
  const trackMetric = (0, _public.useUiTracker)({
    app: 'observability-overview'
  });
  const {
    isGuidedSetupProgressDismissed,
    dismissGuidedSetupProgress
  } = (0, _use_guided_setup_progress.useGuidedSetupProgress)();
  const dismissGuidedSetup = (0, _react.useCallback)(() => {
    dismissGuidedSetupProgress();
    if (onDismissClick) {
      onDismissClick();
    }
    trackMetric({
      metric: 'guided_setup_progress_dismiss'
    });
  }, [dismissGuidedSetupProgress, trackMetric, onDismissClick]);
  const showDetails = () => {
    onViewDetailsClick();
    trackMetric({
      metric: 'guided_setup_progress_view_details'
    });
  };
  return !isGuidedSetupProgressDismissed ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "primary",
    "data-test-subj": "status-progress"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.status.progressBarTitle",
    defaultMessage: "Data assistant for Observability"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.status.progressBarDescription",
    defaultMessage: "Track your progress towards adding observability integrations and features."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    direction: "row",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "o11yObservabilityStatusProgressDismissButton",
    size: "s",
    onClick: dismissGuidedSetup
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.status.progressBarDismiss",
    defaultMessage: "Dismiss"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yObservabilityStatusProgressViewDetailsButton",
    size: "s",
    onClick: showDetails
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.status.progressBarViewDetails",
    defaultMessage: "View details"
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null;
}