"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesPage = CasesPage;
var _react = _interopRequireDefault(require("react"));
var _common = require("../../../common");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _cases = require("./components/cases");
var _feature_no_permissions = require("./components/feature_no_permissions");
var _header_menu = require("../overview/components/header_menu/header_menu");
var _kibana_react = require("../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CasesPage() {
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    canUseCases
  } = (0, _kibana_react.useKibana)().services.cases.helpers;
  const userCasesPermissions = canUseCases([_common.observabilityFeatureId]);
  return userCasesPermissions.read ? /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    isPageDataLoaded: true,
    "data-test-subj": "o11yCasesPage"
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, null), /*#__PURE__*/_react.default.createElement(_cases.Cases, {
    permissions: userCasesPermissions
  })) : /*#__PURE__*/_react.default.createElement(_feature_no_permissions.CaseFeatureNoPermissions, null);
}