"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseAlert = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
var _parse_technical_fields = require("@kbn/rule-registry-plugin/common/parse_technical_fields");
var _parse_experimental_fields = require("@kbn/rule-registry-plugin/common/parse_experimental_fields");
var _formatters = require("../../../../common/utils/formatters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseAlert = observabilityRuleTypeRegistry => alert => {
  var _ref, _parsedFields$ALERT_R, _formatter, _parsedFields$ALERT_S, _parsedFields$TIMESTA;
  const experimentalFields = Object.keys(_alertsAsDataUtils.legacyExperimentalFieldMap);
  const alertWithExperimentalFields = experimentalFields.reduce((acc, key) => {
    if (alert[key]) {
      return {
        ...acc,
        [key]: alert[key]
      };
    }
    return acc;
  }, {});
  const parsedFields = {
    ...(0, _parse_technical_fields.parseTechnicalFields)(alert, true),
    ...(0, _parse_experimental_fields.parseExperimentalFields)(alertWithExperimentalFields, true)
  };
  const formatter = observabilityRuleTypeRegistry.getFormatter(parsedFields[_ruleDataUtils.ALERT_RULE_TYPE_ID]);
  const formatted = {
    link: undefined,
    reason: (_ref = (_parsedFields$ALERT_R = parsedFields[_ruleDataUtils.ALERT_REASON]) !== null && _parsedFields$ALERT_R !== void 0 ? _parsedFields$ALERT_R : parsedFields[_ruleDataUtils.ALERT_RULE_NAME]) !== null && _ref !== void 0 ? _ref : '',
    ...((_formatter = formatter === null || formatter === void 0 ? void 0 : formatter({
      fields: parsedFields,
      formatters: {
        asDuration: _formatters.asDuration,
        asPercent: _formatters.asPercent
      }
    })) !== null && _formatter !== void 0 ? _formatter : {})
  };
  return {
    ...formatted,
    fields: parsedFields,
    active: parsedFields[_ruleDataUtils.ALERT_STATUS] === _ruleDataUtils.ALERT_STATUS_ACTIVE,
    start: new Date((_parsedFields$ALERT_S = parsedFields[_ruleDataUtils.ALERT_START]) !== null && _parsedFields$ALERT_S !== void 0 ? _parsedFields$ALERT_S : 0).getTime(),
    lastUpdated: new Date((_parsedFields$TIMESTA = parsedFields[_ruleDataUtils.TIMESTAMP]) !== null && _parsedFields$TIMESTA !== void 0 ? _parsedFields$TIMESTA : 0).getTime()
  };
};
exports.parseAlert = parseAlert;