"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSummary = AlertSummary;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertSummary({
  alertSummaryFields
}) {
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    responsive: false,
    "data-test-subj": "alert-summary-container",
    style: {
      gridTemplateColumns: isMobile ? 'repeat(2, 1fr)' : 'repeat(5, 1fr)'
    }
  }, alertSummaryFields === null || alertSummaryFields === void 0 ? void 0 : alertSummaryFields.map((field, idx) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: idx
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued"
    }, field.label), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, field.value));
  }));
}