"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ALERT_DETAILS_PAGE_ID = void 0;
exports.AlertDetails = AlertDetails;
exports.METRIC_THRESHOLD_ALERT_TYPE_ID = exports.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = exports.LOG_DOCUMENT_COUNT_RULE_TYPE_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public = require("@kbn/observability-shared-plugin/public");
var _kibana_react = require("../../utils/kibana_react");
var _use_fetch_rule = require("../../hooks/use_fetch_rule");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_fetch_alert_detail = require("../../hooks/use_fetch_alert_detail");
var _page_title = require("./components/page_title");
var _header_actions = require("./components/header_actions");
var _alert_summary = require("./components/alert_summary");
var _center_justified_spinner = require("../../components/center_justified_spinner");
var _ = _interopRequireDefault(require("../404"));
var _get_time_zone = require("../../utils/get_time_zone");
var _is_alert_details_enabled = require("../../utils/is_alert_details_enabled");
var _common = require("../../../common");
var _paths = require("../../../common/locators/paths");
var _header_menu = require("../overview/components/header_menu/header_menu");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_DETAILS_PAGE_ID = 'alert-details-o11y';
exports.ALERT_DETAILS_PAGE_ID = ALERT_DETAILS_PAGE_ID;
const defaultBreadcrumb = _i18n.i18n.translate('xpack.observability.breadcrumbs.alertDetails', {
  defaultMessage: 'Alert details'
});
const LOG_DOCUMENT_COUNT_RULE_TYPE_ID = 'logs.alert.document.count';
exports.LOG_DOCUMENT_COUNT_RULE_TYPE_ID = LOG_DOCUMENT_COUNT_RULE_TYPE_ID;
const METRIC_THRESHOLD_ALERT_TYPE_ID = 'metrics.alert.threshold';
exports.METRIC_THRESHOLD_ALERT_TYPE_ID = METRIC_THRESHOLD_ALERT_TYPE_ID;
const METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = 'metrics.alert.inventory.threshold';
exports.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID;
function AlertDetails() {
  const {
    cases: {
      helpers: {
        canUseCases
      },
      ui: {
        getCasesContext
      }
    },
    http,
    triggersActionsUi: {
      ruleTypeRegistry
    },
    uiSettings
  } = (0, _kibana_react.useKibana)().services;
  const {
    ObservabilityPageTemplate,
    config
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    alertId
  } = (0, _reactRouterDom.useParams)();
  const [isLoading, alert] = (0, _use_fetch_alert_detail.useFetchAlertDetail)(alertId);
  const [ruleTypeModel, setRuleTypeModel] = (0, _react.useState)(null);
  const CasesContext = getCasesContext();
  const userCasesPermissions = canUseCases([_common.observabilityFeatureId]);
  const {
    rule
  } = (0, _use_fetch_rule.useFetchRule)({
    ruleId: alert === null || alert === void 0 ? void 0 : alert.fields[_ruleDataUtils.ALERT_RULE_UUID]
  });
  const [summaryFields, setSummaryFields] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (alert) {
      setRuleTypeModel(ruleTypeRegistry.get(alert === null || alert === void 0 ? void 0 : alert.fields[_ruleDataUtils.ALERT_RULE_TYPE_ID]));
    }
  }, [alert, ruleTypeRegistry]);
  (0, _public.useBreadcrumbs)([{
    href: http.basePath.prepend(_paths.paths.observability.alerts),
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.alertsLinkText', {
      defaultMessage: 'Alerts'
    }),
    deepLinkId: 'observability-overview:alerts'
  }, {
    text: alert ? (0, _page_title.pageTitleContent)(alert.fields[_ruleDataUtils.ALERT_RULE_CATEGORY]) : defaultBreadcrumb
  }]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, null);
  }

  // Redirect to the 404 page when the user hit the page url directly in the browser while the feature flag is off.
  if (alert && !(0, _is_alert_details_enabled.isAlertDetailsEnabledPerApp)(alert, config)) {
    return /*#__PURE__*/_react.default.createElement(_.default, null);
  }
  if (!isLoading && !alert) return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "alertDetailsError"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.observability.alertDetails.errorPromptTitle', {
      defaultMessage: 'Unable to load alert details'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability.alertDetails.errorPromptBody', {
      defaultMessage: 'There was an error loading the alert details.'
    }))
  }));
  const AlertDetailsAppSection = ruleTypeModel ? ruleTypeModel.alertDetailsAppSection : null;
  const timeZone = (0, _get_time_zone.getTimeZone)(uiSettings);
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
        alert: alert,
        dataTestSubj: (rule === null || rule === void 0 ? void 0 : rule.ruleTypeId) || 'alertDetailsPageTitle'
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(CasesContext, {
        owner: [_common.observabilityFeatureId],
        permissions: userCasesPermissions,
        features: {
          alerts: {
            sync: false
          }
        }
      }, /*#__PURE__*/_react.default.createElement(_header_actions.HeaderActions, {
        alert: alert
      }))],
      bottomBorder: true
    },
    "data-test-subj": "alertDetails"
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, null), /*#__PURE__*/_react.default.createElement(_alert_summary.AlertSummary, {
    alertSummaryFields: summaryFields
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), AlertDetailsAppSection && rule && /*#__PURE__*/_react.default.createElement(AlertDetailsAppSection, {
    alert: alert,
    rule: rule,
    timeZone: timeZone,
    setAlertSummaryFields: setSummaryFields,
    ruleLink: http.basePath.prepend(_paths.paths.observability.ruleDetails(rule.id))
  }));
}