"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LOCAL_STORAGE_DISMISS_OBSERVABILITY_ONBOARDING_KEY = void 0;
exports.useObservabilityOnboarding = useObservabilityOnboarding;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCAL_STORAGE_DISMISS_OBSERVABILITY_ONBOARDING_KEY = 'DISMISS_OBSERVABILITY_ONBOARDING';
exports.LOCAL_STORAGE_DISMISS_OBSERVABILITY_ONBOARDING_KEY = LOCAL_STORAGE_DISMISS_OBSERVABILITY_ONBOARDING_KEY;
function useObservabilityOnboarding() {
  const dismissedObservabilityOnboardingLocalStorage = window.localStorage.getItem(LOCAL_STORAGE_DISMISS_OBSERVABILITY_ONBOARDING_KEY);
  const [isObservabilityOnboardingDismissed, setIsObservabilityOnboardingDismissed] = (0, _react.useState)(JSON.parse(dismissedObservabilityOnboardingLocalStorage || 'false'));
  const dismissObservabilityOnboarding = (0, _react.useCallback)(() => {
    window.localStorage.setItem(LOCAL_STORAGE_DISMISS_OBSERVABILITY_ONBOARDING_KEY, 'true');
    setIsObservabilityOnboardingDismissed(true);
  }, []);
  return {
    isObservabilityOnboardingDismissed,
    dismissObservabilityOnboarding
  };
}