"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResetSlo = useResetSlo;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useResetSlo() {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  return (0, _reactQuery.useMutation)(['resetSlo'], ({
    id,
    name
  }) => {
    try {
      return http.post(`/api/observability/slos/${id}/_reset`);
    } catch (error) {
      return Promise.reject(_i18n.i18n.translate('xpack.observability.slo.slo.reset.errorMessage', {
        defaultMessage: 'Failed to reset {name} (id: {id}), something went wrong: {error}',
        values: {
          error: String(error),
          name,
          id
        }
      }));
    }
  }, {
    onError: (error, {
      name,
      id
    }) => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.observability.slo.slo.reset.errorNotification', {
          defaultMessage: 'Failed to reset {name} (id: {id})',
          values: {
            name,
            id
          }
        })
      });
    },
    onSuccess: (_data, {
      name
    }) => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.observability.slo.slo.reset.successNotification', {
        defaultMessage: '{name} reset successfully',
        values: {
          name
        }
      }));
    }
  });
}