"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchHistoricalSummary = useFetchHistoricalSummary;
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../../utils/kibana_react");
var _query_key_factory = require("./query_key_factory");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchHistoricalSummary({
  list = [],
  shouldRefetch
}) {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.historicalSummary(list),
    queryFn: async ({
      signal
    }) => {
      try {
        const response = await http.post('/internal/observability/slos/_historical_summary', {
          body: JSON.stringify({
            list
          }),
          signal
        });
        return response;
      } catch (error) {
        // ignore error
      }
    },
    refetchInterval: shouldRefetch ? _constants.SLO_LONG_REFETCH_INTERVAL : undefined,
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
  return {
    data,
    isLoading,
    isRefetching,
    isInitialLoading,
    isSuccess,
    isError
  };
}