"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCloneSlo = useCloneSlo;
var _rison = require("@kbn/rison");
var _react = require("react");
var _paths = require("../../../common/locators/paths");
var _kibana_react = require("../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCloneSlo() {
  const {
    http: {
      basePath
    },
    application: {
      navigateToUrl
    }
  } = (0, _kibana_react.useKibana)().services;
  return (0, _react.useCallback)(slo => {
    navigateToUrl(basePath.prepend(_paths.paths.observability.sloCreateWithEncodedForm((0, _rison.encode)({
      ...slo,
      name: `[Copy] ${slo.name}`,
      id: undefined
    }))));
  }, [navigateToUrl, basePath]);
}