"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCapabilities = useCapabilities;
var _common = require("../../../common");
var _kibana_react = require("../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCapabilities() {
  var _capabilities$sloFeat, _capabilities$sloFeat2;
  const {
    application: {
      capabilities
    }
  } = (0, _kibana_react.useKibana)().services;
  return {
    hasReadCapabilities: (_capabilities$sloFeat = !!capabilities[_common.sloFeatureId].read) !== null && _capabilities$sloFeat !== void 0 ? _capabilities$sloFeat : false,
    hasWriteCapabilities: (_capabilities$sloFeat2 = !!capabilities[_common.sloFeatureId].write) !== null && _capabilities$sloFeat2 !== void 0 ? _capabilities$sloFeat2 : false
  };
}