"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingContent = exports.LoadingContainer = void 0;
exports.SloOverview = SloOverview;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _sloSchema = require("@kbn/slo-schema");
var _badges_portal = require("../../../pages/slos/components/card_view/badges_portal");
var _chart_data_formatter = require("../../../utils/slo/chart_data_formatter");
var _use_fetch_historical_summary = require("../../../hooks/slo/use_fetch_historical_summary");
var _use_fetch_active_alerts = require("../../../hooks/slo/use_fetch_active_alerts");
var _use_fetch_rules_for_slo = require("../../../hooks/slo/use_fetch_rules_for_slo");
var _slo_card_item_badges = require("../../../pages/slos/components/card_view/slo_card_item_badges");
var _slo_card_item = require("../../../pages/slos/components/card_view/slo_card_item");
var _use_fetch_slo_details = require("../../../hooks/slo/use_fetch_slo_details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloOverview({
  sloId,
  sloInstanceId,
  onRenderComplete,
  reloadSubject
}) {
  var _slo$instanceId, _slo$instanceId2, _historicalSummaries$;
  const containerRef = (0, _react.useRef)(null);
  const [lastRefreshTime, setLastRefreshTime] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    reloadSubject === null || reloadSubject === void 0 ? void 0 : reloadSubject.subscribe(() => {
      setLastRefreshTime(Date.now());
    });
    return () => {
      reloadSubject === null || reloadSubject === void 0 ? void 0 : reloadSubject.unsubscribe();
    };
  }, [reloadSubject]);
  const {
    isLoading,
    data: slo,
    refetch,
    isRefetching
  } = (0, _use_fetch_slo_details.useFetchSloDetails)({
    sloId,
    instanceId: sloInstanceId
  });
  const {
    data: rulesBySlo
  } = (0, _use_fetch_rules_for_slo.useFetchRulesForSlo)({
    sloIds: sloId ? [sloId] : []
  });
  const {
    data: activeAlertsBySlo
  } = (0, _use_fetch_active_alerts.useFetchActiveAlerts)({
    sloIdsAndInstanceIds: slo ? [[slo.id, (_slo$instanceId = slo.instanceId) !== null && _slo$instanceId !== void 0 ? _slo$instanceId : _sloSchema.ALL_VALUE]] : []
  });
  const {
    data: historicalSummaries = []
  } = (0, _use_fetch_historical_summary.useFetchHistoricalSummary)({
    list: slo ? [{
      sloId: slo.id,
      instanceId: (_slo$instanceId2 = slo.instanceId) !== null && _slo$instanceId2 !== void 0 ? _slo$instanceId2 : _sloSchema.ALL_VALUE
    }] : []
  });
  (0, _react.useEffect)(() => {
    refetch();
  }, [lastRefreshTime, refetch]);
  (0, _react.useEffect)(() => {
    if (!onRenderComplete) return;
    if (!isLoading) {
      onRenderComplete();
    }
  }, [isLoading, onRenderComplete]);
  const isSloNotFound = !isLoading && slo === undefined;
  if (isRefetching || isLoading || !slo) {
    return /*#__PURE__*/_react.default.createElement(LoadingContainer, null, /*#__PURE__*/_react.default.createElement(LoadingContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, null)));
  }
  if (isSloNotFound) {
    return /*#__PURE__*/_react.default.createElement(LoadingContainer, null, /*#__PURE__*/_react.default.createElement(LoadingContent, null, _i18n.i18n.translate('xpack.observability.sloEmbeddable.overview.sloNotFoundText', {
      defaultMessage: 'The SLO has been deleted. You can safely delete the widget from the dashboard.'
    })));
  }
  const rules = rulesBySlo === null || rulesBySlo === void 0 ? void 0 : rulesBySlo[slo === null || slo === void 0 ? void 0 : slo.id];
  const activeAlerts = activeAlertsBySlo.get(slo);
  const hasGroupBy = Boolean(slo.groupBy && slo.groupBy !== _sloSchema.ALL_VALUE);
  const historicalSummary = (_historicalSummaries$ = historicalSummaries.find(histSummary => {
    var _slo$instanceId3;
    return histSummary.sloId === slo.id && histSummary.instanceId === ((_slo$instanceId3 = slo.instanceId) !== null && _slo$instanceId3 !== void 0 ? _slo$instanceId3 : _sloSchema.ALL_VALUE);
  })) === null || _historicalSummaries$ === void 0 ? void 0 : _historicalSummaries$.data;
  const historicalSliData = (0, _chart_data_formatter.formatHistoricalData)(historicalSummary, 'sli_value');
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: containerRef,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_slo_card_item.SloCardChart, {
    slo: slo,
    historicalSliData: historicalSliData !== null && historicalSliData !== void 0 ? historicalSliData : []
  }), /*#__PURE__*/_react.default.createElement(_badges_portal.SloCardBadgesPortal, {
    containerRef: containerRef
  }, /*#__PURE__*/_react.default.createElement(_slo_card_item_badges.SloCardItemBadges, {
    slo: slo,
    rules: rules,
    activeAlerts: activeAlerts,
    hasGroupBy: hasGroupBy
  })));
}
const LoadingContainer = _common.euiStyled.div`
  position: relative;
  overflow: hidden;
  display: flex;
  flex-direction: column;
  justify-content: center;
  width: 100%;
  height: 100%;
`;
exports.LoadingContainer = LoadingContainer;
const LoadingContent = _common.euiStyled.div`
  flex: 0 0 auto;
  align-self: center;
  text-align: center;
`;
exports.LoadingContent = LoadingContent;