"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveEmbeddableSloUserInput = resolveEmbeddableSloUserInput;
var _react = _interopRequireDefault(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactQuery = require("@tanstack/react-query");
var _slo_configuration = require("./slo_configuration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolveEmbeddableSloUserInput(coreStart, pluginStart, input) {
  const {
    overlays
  } = coreStart;
  const queryClient = new _reactQuery.QueryClient();
  return new Promise(async (resolve, reject) => {
    try {
      const modalSession = overlays.openModal((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
        services: {
          ...coreStart,
          ...pluginStart
        }
      }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
        client: queryClient
      }, /*#__PURE__*/_react.default.createElement(_slo_configuration.SloConfiguration, {
        onCreate: update => {
          modalSession.close();
          resolve(update);
        },
        onCancel: () => {
          modalSession.close();
          reject();
        }
      }))), {
        i18n: coreStart.i18n,
        theme: coreStart.theme
      }));
    } catch (error) {
      reject(error);
    }
  });
}