"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloAlertsSummary = SloAlertsSummary;
var _react = _interopRequireWildcard(require("react"));
var _slo_alerts_table = require("./slo_alerts_table");
var _alert_summary_widget = require("../../../../utils/alert_summary_widget");
var _constants = require("../../../../../common/constants");
var _use_time_buckets = require("../../../../hooks/use_time_buckets");
var _calculate_bucket_size = require("../../../../pages/overview/helpers/calculate_bucket_size");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_INTERVAL = '60s';
const DEFAULT_DATE_FORMAT = 'YYYY-MM-DD HH:mm';
function SloAlertsSummary({
  slos,
  deps,
  timeRange,
  onLoaded
}) {
  const {
    charts,
    triggersActionsUi: {
      getAlertSummaryWidget: AlertSummaryWidget
    }
  } = deps;
  const esQuery = (0, _slo_alerts_table.useSloAlertsQuery)(slos, timeRange);
  const timeBuckets = (0, _use_time_buckets.useTimeBuckets)();
  const bucketSize = (0, _react.useMemo)(() => (0, _calculate_bucket_size.calculateTimeRangeBucketSize)({
    from: timeRange.from,
    to: timeRange.to
  }, timeBuckets), [timeRange.from, timeRange.to, timeBuckets]);
  const alertSummaryTimeRange = (0, _react.useMemo)(() => {
    var _bucketSize$intervalS, _bucketSize$dateForma;
    return (0, _alert_summary_widget.getAlertSummaryTimeRange)({
      from: timeRange.from,
      to: timeRange.to
    }, (_bucketSize$intervalS = bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.intervalString) !== null && _bucketSize$intervalS !== void 0 ? _bucketSize$intervalS : DEFAULT_INTERVAL, (_bucketSize$dateForma = bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.dateFormat) !== null && _bucketSize$dateForma !== void 0 ? _bucketSize$dateForma : DEFAULT_DATE_FORMAT);
  }, [timeRange.from, timeRange.to, bucketSize]);
  const chartProps = {
    theme: charts.theme.useChartsTheme(),
    baseTheme: charts.theme.useChartsBaseTheme()
  };
  return /*#__PURE__*/_react.default.createElement(AlertSummaryWidget, {
    featureIds: _constants.observabilityAlertFeatureIds,
    filter: esQuery,
    timeRange: alertSummaryTimeRange,
    chartProps: chartProps,
    fullSize: true,
    onLoaded: () => {
      if (onLoaded) {
        onLoaded();
      }
    }
  });
}