"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExpressionData = useExpressionData;
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _kuery = require("../helpers/kuery");
var _runtime_types = require("../helpers/runtime_types");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useExpressionData(options, derivedIndexPattern, {
  fromTimestamp,
  toTimestamp,
  interval,
  timeFieldName
}, enabled = true) {
  const {
    http
  } = (0, _public.useKibana)().services;
  const {
    isLoading,
    data,
    error,
    refetch,
    fetchNextPage
  } = (0, _reactQuery.useInfiniteQuery)({
    queryKey: ['metricExplorer', options, fromTimestamp, toTimestamp, derivedIndexPattern.title],
    queryFn: async ({
      signal,
      pageParam = {
        afterKey: null
      }
    }) => {
      if (!fromTimestamp || !toTimestamp) {
        throw new Error('Unable to parse timerange');
      }
      if (!http) {
        throw new Error('HTTP service is unavailable');
      }
      if (!derivedIndexPattern.title) {
        throw new Error('Data view is unavailable');
      }
      const {
        afterKey
      } = pageParam;
      const response = await http.post('/api/infra/metrics_explorer', {
        method: 'POST',
        body: JSON.stringify({
          forceInterval: options.forceInterval,
          dropLastBucket: options.dropLastBucket != null ? options.dropLastBucket : true,
          metrics: options.metrics,
          groupBy: options.groupBy,
          afterKey,
          limit: options.limit,
          indexPattern: derivedIndexPattern.title,
          filterQuery: options.filterQuery && (0, _kuery.convertKueryToElasticSearchQuery)(options.filterQuery, derivedIndexPattern) || void 0,
          timerange: {
            interval,
            timeFieldName,
            from: fromTimestamp,
            to: toTimestamp
          }
        }),
        signal
      });
      return (0, _runtime_types.decodeOrThrow)(_types.metricsExplorerResponseRT)(response);
    },
    getNextPageParam: lastPage => lastPage.pageInfo,
    enabled: enabled && !!fromTimestamp && !!toTimestamp && !!http && !!derivedIndexPattern.title,
    refetchOnWindowFocus: false
  });
  return {
    data,
    error,
    fetchNextPage,
    isLoading,
    refetch
  };
}