"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.adjustThresholdBasedOnFormat = void 0;
var _corrected_percent_convert = require("./corrected_percent_convert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const adjustThresholdBasedOnFormat = (previous, next, threshold) => {
  var _previous$0$field, _next$0$field;
  const isPreviousPercent = Boolean(previous.length === 1 && ((_previous$0$field = previous[0].field) === null || _previous$0$field === void 0 ? void 0 : _previous$0$field.endsWith('.pct')));
  const isPercent = Boolean(next.length === 1 && ((_next$0$field = next[0].field) === null || _next$0$field === void 0 ? void 0 : _next$0$field.endsWith('.pct')));
  return isPercent === isPreviousPercent ? threshold : isPercent ? threshold.map(v => (0, _corrected_percent_convert.pctToDecimal)(v)) : isPreviousPercent ? threshold.map(v => (0, _corrected_percent_convert.decimalToPct)(v)) : threshold;
};
exports.adjustThresholdBasedOnFormat = adjustThresholdBasedOnFormat;