"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Expressions;
exports.defaultExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _public = require("@kbn/stack-alerts-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _kibana_react = require("../../utils/kibana_react");
var _types = require("../../../common/custom_threshold_rule/types");
var _expression_row = require("./components/expression_row");
var _group_by = require("./components/group_by");
var _preview_chart = require("./components/preview_chart/preview_chart");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILTER_TYPING_DEBOUNCE_MS = 500;
const defaultExpression = {
  comparator: _types.Comparator.GT,
  metrics: [{
    name: 'A',
    aggType: _types.Aggregators.COUNT
  }],
  threshold: [100],
  timeSize: 1,
  timeUnit: 'm'
};

// eslint-disable-next-line import/no-default-export
exports.defaultExpression = defaultExpression;
function Expressions(props) {
  var _ruleParams$searchCon2;
  const {
    setRuleParams,
    ruleParams,
    errors,
    metadata,
    onChangeMetaData
  } = props;
  const {
    data,
    dataViews,
    dataViewEditor,
    docLinks,
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _kibana_react.useKibana)().services;
  const [timeSize, setTimeSize] = (0, _react.useState)(1);
  const [timeUnit, setTimeUnit] = (0, _react.useState)('m');
  const [dataView, setDataView] = (0, _react.useState)();
  const [dataViewTimeFieldError, setDataViewTimeFieldError] = (0, _react.useState)();
  const [searchSource, setSearchSource] = (0, _react.useState)();
  const [paramsError, setParamsError] = (0, _react.useState)();
  const derivedIndexPattern = (0, _react.useMemo)(() => ({
    fields: (dataView === null || dataView === void 0 ? void 0 : dataView.fields) || [],
    title: (dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern()) || 'unknown-index'
  }), [dataView]);
  (0, _react.useEffect)(() => {
    const initSearchSource = async () => {
      let initialSearchConfiguration = ruleParams.searchConfiguration;
      if (!ruleParams.searchConfiguration || !ruleParams.searchConfiguration.index) {
        const newSearchSource = data.search.searchSource.createEmpty();
        newSearchSource.setField('query', data.query.queryString.getDefaultQuery());
        const defaultDataView = await data.dataViews.getDefaultDataView();
        if (defaultDataView) {
          newSearchSource.setField('index', defaultDataView);
          setDataView(defaultDataView);
        }
        initialSearchConfiguration = newSearchSource.getSerializedFields();
      }
      try {
        var _ruleParams$searchCon;
        const createdSearchSource = await data.search.searchSource.create(initialSearchConfiguration);
        setRuleParams('searchConfiguration', {
          ...initialSearchConfiguration,
          ...(((_ruleParams$searchCon = ruleParams.searchConfiguration) === null || _ruleParams$searchCon === void 0 ? void 0 : _ruleParams$searchCon.query) && {
            query: ruleParams.searchConfiguration.query
          })
        });
        setSearchSource(createdSearchSource);
        setDataView(createdSearchSource.getField('index'));
        if (createdSearchSource.getField('index')) {
          var _createdSearchSource$;
          const timeFieldName = (_createdSearchSource$ = createdSearchSource.getField('index')) === null || _createdSearchSource$ === void 0 ? void 0 : _createdSearchSource$.timeFieldName;
          if (!timeFieldName) {
            setDataViewTimeFieldError(_i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.dataViewError.noTimestamp', {
              defaultMessage: 'The selected data view does not have a timestamp field, please select another data view.'
            }));
          } else {
            setDataViewTimeFieldError(undefined);
          }
        } else {
          setDataViewTimeFieldError(undefined);
        }
      } catch (error) {
        setParamsError(error);
      }
    };
    initSearchSource();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [data.search.searchSource, data.dataViews, dataView]);
  (0, _react.useEffect)(() => {
    if (ruleParams.criteria && ruleParams.criteria.length) {
      setTimeSize(ruleParams.criteria[0].timeSize);
      setTimeUnit(ruleParams.criteria[0].timeUnit);
    } else {
      setRuleParams('criteria', [defaultExpression]);
    }
    if (typeof ruleParams.alertOnNoData === 'undefined') {
      setRuleParams('alertOnNoData', true);
    }
    if (typeof ruleParams.alertOnGroupDisappear === 'undefined') {
      setRuleParams('alertOnGroupDisappear', true);
    }
  }, [metadata]); // eslint-disable-line react-hooks/exhaustive-deps

  const onSelectDataView = (0, _react.useCallback)(newDataView => {
    const ruleCriteria = (ruleParams.criteria ? ruleParams.criteria.slice() : []).map(criterion => {
      var _criterion$metrics;
      (_criterion$metrics = criterion.metrics) === null || _criterion$metrics === void 0 ? void 0 : _criterion$metrics.forEach(metric => {
        metric.field = undefined;
      });
      return criterion;
    });
    setRuleParams('criteria', ruleCriteria);
    searchSource === null || searchSource === void 0 ? void 0 : searchSource.setParent(undefined).setField('index', newDataView);
    setRuleParams('searchConfiguration', searchSource === null || searchSource === void 0 ? void 0 : searchSource.getSerializedFields());
    setDataView(newDataView);
  }, [ruleParams.criteria, searchSource, setRuleParams]);
  const updateParams = (0, _react.useCallback)((id, e) => {
    const ruleCriteria = ruleParams.criteria ? ruleParams.criteria.slice() : [];
    ruleCriteria[id] = e;
    setRuleParams('criteria', ruleCriteria);
  }, [setRuleParams, ruleParams.criteria]);
  const addExpression = (0, _react.useCallback)(() => {
    var _ruleParams$criteria;
    const ruleCriteria = ((_ruleParams$criteria = ruleParams.criteria) === null || _ruleParams$criteria === void 0 ? void 0 : _ruleParams$criteria.slice()) || [];
    ruleCriteria.push({
      ...defaultExpression,
      timeSize: timeSize !== null && timeSize !== void 0 ? timeSize : defaultExpression.timeSize,
      timeUnit: timeUnit !== null && timeUnit !== void 0 ? timeUnit : defaultExpression.timeUnit
    });
    setRuleParams('criteria', ruleCriteria);
  }, [setRuleParams, ruleParams.criteria, timeSize, timeUnit]);
  const removeExpression = (0, _react.useCallback)(id => {
    var _ruleParams$criteria2;
    const ruleCriteria = ((_ruleParams$criteria2 = ruleParams.criteria) === null || _ruleParams$criteria2 === void 0 ? void 0 : _ruleParams$criteria2.filter((_, index) => index !== id)) || [];
    setRuleParams('criteria', ruleCriteria);
  }, [setRuleParams, ruleParams.criteria]);
  const onFilterChange = (0, _react.useCallback)(({
    query
  }) => {
    setRuleParams('searchConfiguration', {
      ...ruleParams.searchConfiguration,
      query
    });
  }, [setRuleParams, ruleParams.searchConfiguration]);

  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const debouncedOnFilterChange = (0, _react.useCallback)((0, _lodash.debounce)(onFilterChange, FILTER_TYPING_DEBOUNCE_MS), [onFilterChange]);
  const onGroupByChange = (0, _react.useCallback)(group => {
    setRuleParams('groupBy', group && group.length ? group : '');
  }, [setRuleParams]);
  const emptyError = (0, _react.useMemo)(() => {
    return {
      aggField: [],
      timeSizeUnit: [],
      timeWindowSize: []
    };
  }, []);
  const updateTimeSize = (0, _react.useCallback)(ts => {
    var _ruleParams$criteria3;
    const ruleCriteria = ((_ruleParams$criteria3 = ruleParams.criteria) === null || _ruleParams$criteria3 === void 0 ? void 0 : _ruleParams$criteria3.map(c => ({
      ...c,
      timeSize: ts
    }))) || [];
    setTimeSize(ts || undefined);
    setRuleParams('criteria', ruleCriteria);
  }, [ruleParams.criteria, setRuleParams]);
  const updateTimeUnit = (0, _react.useCallback)(tu => {
    var _ruleParams$criteria4;
    const ruleCriteria = ((_ruleParams$criteria4 = ruleParams.criteria) === null || _ruleParams$criteria4 === void 0 ? void 0 : _ruleParams$criteria4.map(c => ({
      ...c,
      timeUnit: tu
    }))) || [];
    setTimeUnit(tu);
    setRuleParams('criteria', ruleCriteria);
  }, [ruleParams.criteria, setRuleParams]);
  const hasGroupBy = (0, _react.useMemo)(() => ruleParams.groupBy && ruleParams.groupBy.length > 0, [ruleParams.groupBy]);

  // Test to see if any of the group fields in groupBy are already filtered down to a single
  // group by the filterQuery. If this is the case, then a groupBy is unnecessary, as it would only
  // ever produce one group instance
  const groupByFilterTestPatterns = (0, _react.useMemo)(() => {
    if (!ruleParams.groupBy) return null;
    const groups = !Array.isArray(ruleParams.groupBy) ? [ruleParams.groupBy] : ruleParams.groupBy;
    return groups.map(group => ({
      groupName: group,
      pattern: new RegExp(`{"match(_phrase)?":{"${group}":"(.*?)"}}`)
    }));
  }, [ruleParams.groupBy]);
  const redundantFilterGroupBy = (0, _react.useMemo)(() => {
    const {
      filterQuery
    } = ruleParams;
    if (typeof filterQuery !== 'string' || !groupByFilterTestPatterns) return [];
    return groupByFilterTestPatterns.map(({
      groupName,
      pattern
    }) => {
      if (pattern.test(filterQuery)) {
        return groupName;
      }
    }).filter(g => typeof g === 'string');
  }, [ruleParams, groupByFilterTestPatterns]);
  if (paramsError) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      iconType: "warning",
      "data-test-subj": "thresholdRuleExpressionError"
    }, /*#__PURE__*/_react.default.createElement("p", null, paramsError.message)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 'm'
    }));
  }
  if (!searchSource) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl"
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }
  const placeHolder = _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.searchBar.placeholder', {
    defaultMessage: 'Search for observability data… (e.g. host.name:host-1)'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.rule.alertFlyout.selectDataViewPrompt",
    defaultMessage: "Select a data view"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_public.DataViewSelectPopover, {
    dependencies: {
      dataViews,
      dataViewEditor
    },
    dataView: dataView,
    metadata: {
      adHocDataViewList: (metadata === null || metadata === void 0 ? void 0 : metadata.adHocDataViewList) || []
    },
    onSelectDataView: onSelectDataView,
    onChangeMetaData: ({
      adHocDataViewList
    }) => {
      onChangeMetaData({
        ...metadata,
        adHocDataViewList
      });
    }
  }), dataViewTimeFieldError && /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
    "data-test-subj": "thresholdRuleDataViewErrorNoTimestamp"
  }, dataViewTimeFieldError), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.rule.alertFlyout.defineTextQueryPrompt",
    defaultMessage: "Define query filter (optional)"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: "Custom threshold rule",
    iconType: "search",
    placeholder: placeHolder,
    indexPatterns: dataView ? [dataView] : undefined,
    showQueryInput: true,
    showQueryMenu: false,
    showFilterBar: false,
    showDatePicker: false,
    showSubmitButton: false,
    displayStyle: "inPage",
    onQueryChange: debouncedOnFilterChange,
    onQuerySubmit: onFilterChange,
    dataTestSubj: "thresholdRuleUnifiedSearchBar",
    query: (_ruleParams$searchCon2 = ruleParams.searchConfiguration) === null || _ruleParams$searchCon2 === void 0 ? void 0 : _ruleParams$searchCon2.query
  }), errors.filterQuery && /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
    "data-test-subj": "thresholdRuleDataViewErrorNoTimestamp"
  }, errors.filterQuery), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), ruleParams.criteria && ruleParams.criteria.map((e, idx) => {
    var _ruleParams$searchCon3, _ruleParams$searchCon4;
    return /*#__PURE__*/_react.default.createElement("div", {
      key: idx
    }, idx > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "s"
    }), /*#__PURE__*/_react.default.createElement(_expression_row.ExpressionRow, {
      canDelete: ruleParams.criteria && ruleParams.criteria.length > 1 || false,
      fields: derivedIndexPattern.fields,
      remove: removeExpression,
      addExpression: addExpression,
      key: idx // idx's don't usually make good key's but here the index has semantic meaning
      ,
      expressionId: idx,
      setRuleParams: updateParams,
      errors: errors[idx] || emptyError,
      expression: e || {},
      dataView: derivedIndexPattern,
      title: ruleParams.criteria.length === 1 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability.customThreshold.rule.alertFlyout.setConditions",
        defaultMessage: "Set rule conditions"
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability.customThreshold.rule.alertFlyout.condition",
        defaultMessage: "Condition {conditionNumber}",
        values: {
          conditionNumber: idx + 1
        }
      })
    }, /*#__PURE__*/_react.default.createElement(_preview_chart.PreviewChart, {
      metricExpression: e,
      dataView: dataView,
      filterQuery: (_ruleParams$searchCon3 = ruleParams.searchConfiguration) === null || _ruleParams$searchCon3 === void 0 ? void 0 : (_ruleParams$searchCon4 = _ruleParams$searchCon3.query) === null || _ruleParams$searchCon4 === void 0 ? void 0 : _ruleParams$searchCon4.query,
      groupBy: ruleParams.groupBy,
      error: errors[idx] || emptyError
    })));
  }), /*#__PURE__*/_react.default.createElement(_public2.ForLastExpression, {
    timeWindowSize: timeSize,
    timeWindowUnit: timeUnit,
    errors: emptyError,
    onChangeWindowSize: updateTimeSize,
    onChangeWindowUnit: updateTimeUnit,
    display: "fullWidth"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "thresholdRuleExpressionsAddConditionButton",
    color: "primary",
    iconSide: "left",
    flush: "left",
    iconType: "plusInCircleFilled",
    onClick: addExpression
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.rule.alertFlyout.addCondition",
    defaultMessage: "Add condition"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.createAlertPerText', {
      defaultMessage: 'Group alerts by (optional)'
    }),
    helpText: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.createAlertPerHelpText', {
      defaultMessage: 'Create an alert for every unique value. For example: "host.id" or "cloud.region".'
    }),
    fullWidth: true,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_group_by.GroupBy, {
    onChange: onGroupByChange,
    fields: derivedIndexPattern.fields,
    options: {
      groupBy: ruleParams.groupBy || null
    },
    errorOptions: redundantFilterGroupBy
  })), redundantFilterGroupBy.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.rule.alertFlyout.alertPerRedundantFilterError",
    defaultMessage: "This rule may alert on {matchedGroups} less than expected, because the filter query contains a match for {groupCount, plural, one {this field} other {these fields}}. For more information, refer to {filteringAndGroupingLink}.",
    values: {
      matchedGroups: /*#__PURE__*/_react.default.createElement("strong", null, redundantFilterGroupBy.join(', ')),
      groupCount: redundantFilterGroupBy.length,
      filteringAndGroupingLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "thresholdRuleExpressionsTheDocsLink",
        href: `${docLinks.links.observability.metricsThreshold}#filtering-and-grouping`
      }, _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.alertPerRedundantFilterError.docsLink', {
        defaultMessage: 'the docs'
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "metrics-alert-group-disappear-toggle",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.alertOnGroupDisappear', {
      defaultMessage: 'Alert me if a group stops reporting data'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.groupDisappearHelpText', {
        defaultMessage: 'Enable this to trigger the action if a previously detected group begins to report no results. This is not recommended for dynamically scaling infrastructures that may rapidly start and stop nodes automatically.'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "questionInCircle",
      color: "subdued"
    }))),
    disabled: !hasGroupBy,
    checked: Boolean(hasGroupBy && ruleParams.alertOnGroupDisappear),
    onChange: e => setRuleParams('alertOnGroupDisappear', e.target.checked)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
}