"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThresholdAnnotations = ThresholdAnnotations;
var _charts = require("@elastic/charts");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _color_palette = require("../../../../../common/custom_threshold_rule/color_palette");
var _types = require("../../../../../common/custom_threshold_rule/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const opacity = 0.3;
function ThresholdAnnotations({
  threshold,
  sortedThresholds,
  comparator,
  color,
  id,
  firstTimestamp,
  lastTimestamp,
  domain
}) {
  if (!comparator || !threshold) return null;
  const isAbove = [_types.Comparator.GT, _types.Comparator.GT_OR_EQ].includes(comparator);
  const isBelow = [_types.Comparator.LT, _types.Comparator.LT_OR_EQ].includes(comparator);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: `${id}-thresholds`,
    domainType: _charts.AnnotationDomainType.YDomain,
    "data-test-subj": "threshold-line",
    dataValues: sortedThresholds.map(t => ({
      dataValue: t
    })),
    style: {
      line: {
        strokeWidth: 2,
        stroke: (0, _color_palette.colorTransformer)(color),
        opacity: 1
      }
    }
  }), sortedThresholds.length === 2 && comparator === _types.Comparator.BETWEEN ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    id: `${id}-lower-threshold`,
    "data-test-subj": "between-rect",
    style: {
      fill: (0, _color_palette.colorTransformer)(color),
      opacity
    },
    dataValues: [{
      coordinates: {
        x0: firstTimestamp,
        x1: lastTimestamp,
        y0: (0, _lodash.first)(threshold),
        y1: (0, _lodash.last)(threshold)
      }
    }]
  })) : null, sortedThresholds.length === 2 && comparator === _types.Comparator.OUTSIDE_RANGE ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    id: `${id}-lower-threshold`,
    "data-test-subj": "outside-range-lower-rect",
    style: {
      fill: (0, _color_palette.colorTransformer)(color),
      opacity
    },
    dataValues: [{
      coordinates: {
        x0: firstTimestamp,
        x1: lastTimestamp,
        y0: domain.min,
        y1: (0, _lodash.first)(threshold)
      }
    }]
  }), /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    id: `${id}-upper-threshold`,
    "data-test-subj": "outside-range-upper-rect",
    style: {
      fill: (0, _color_palette.colorTransformer)(color),
      opacity
    },
    dataValues: [{
      coordinates: {
        x0: firstTimestamp,
        x1: lastTimestamp,
        y0: (0, _lodash.last)(threshold),
        y1: domain.max
      }
    }]
  })) : null, isBelow && (0, _lodash.first)(threshold) != null ? /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    id: `${id}-upper-threshold`,
    "data-test-subj": "below-rect",
    style: {
      fill: (0, _color_palette.colorTransformer)(color),
      opacity
    },
    dataValues: [{
      coordinates: {
        x0: firstTimestamp,
        x1: lastTimestamp,
        y0: domain.min,
        y1: (0, _lodash.first)(threshold)
      }
    }]
  }) : null, isAbove && (0, _lodash.first)(threshold) != null ? /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    id: `${id}-upper-threshold`,
    "data-test-subj": "above-rect",
    style: {
      fill: (0, _color_palette.colorTransformer)(color),
      opacity
    },
    dataValues: [{
      coordinates: {
        x0: firstTimestamp,
        x1: lastTimestamp,
        y0: (0, _lodash.first)(threshold),
        y1: domain.max
      }
    }]
  }) : null);
}