"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BudgetConsumed = BudgetConsumed;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function BudgetConsumed({
  onChange,
  initialBurnRate = 1,
  longLookbackWindowInHours,
  sloTimeWindowInHours,
  errors
}) {
  const [budgetConsumed, setBudgetConsumed] = (0, _react.useState)(initialBurnRate * longLookbackWindowInHours / sloTimeWindowInHours * 100);
  const [formattedValue, setFormattedValue] = (0, _react.useState)(budgetConsumed.toFixed(2));
  const hasError = errors !== undefined && errors.length > 0;
  const onBudgetConsumedChanged = event => {
    const value = Number(event.target.value);
    setBudgetConsumed(value);
    const burnRate = sloTimeWindowInHours * (value / 100 / longLookbackWindowInHours);
    onChange(burnRate);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.observability.slo.rules.budgetConsumed.rowLabel', {
      defaultMessage: '% Budget consumed'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.observability.slo.rules.budgetConsumed.tooltip', {
        defaultMessage: 'How much budget is consumed before the first alert is fired.'
      })
    })),
    fullWidth: true,
    isInvalid: hasError
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    step: 0.01,
    min: 0.01,
    max: 100,
    value: formattedValue,
    onChange: event => {
      onBudgetConsumedChanged(event);
      setFormattedValue(event.target.value);
    },
    onBlur: event => {
      const value = event.target.value;
      setFormattedValue(Number(value).toFixed(2));
    },
    "data-test-subj": "budgetConsumed"
  }));
}