"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsFlyoutFooter = AlertsFlyoutFooter;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../utils/kibana_react");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _is_alert_details_enabled = require("../../utils/is_alert_details_enabled");
var _paths = require("../../../common/locators/paths");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertsFlyoutFooter({
  alert,
  isInApp
}) {
  const {
    http: {
      basePath: {
        prepend
      }
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    config
  } = (0, _use_plugin_context.usePluginContext)();
  const [viewInAppUrl, setViewInAppUrl] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (!alert.hasBasePath) {
      var _alert$link;
      setViewInAppUrl(prepend((_alert$link = alert.link) !== null && _alert$link !== void 0 ? _alert$link : ''));
    } else {
      setViewInAppUrl(alert.link);
    }
  }, [alert.hasBasePath, alert.link, prepend]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, !alert.link || isInApp ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "alertsFlyoutViewInAppButton",
    fill: true,
    href: viewInAppUrl
  }, _i18n.i18n.translate('xpack.observability.alertsFlyout.viewInAppButtonText', {
    defaultMessage: 'View in app'
  }))), !(0, _is_alert_details_enabled.isAlertDetailsEnabledPerApp)(alert, config) ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "alertsFlyoutAlertDetailsButton",
    fill: true,
    href: prepend && prepend(_paths.paths.observability.alertDetails(alert.fields['kibana.alert.uuid']))
  }, _i18n.i18n.translate('xpack.observability.alertsFlyout.alertsDetailsButtonText', {
    defaultMessage: 'Alert details'
  })))));
}