"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSLOTransformId = exports.getSLOSummaryTransformId = exports.getSLOSummaryPipelineId = exports.SLO_SUMMARY_TEMP_INDEX_NAME = exports.SLO_SUMMARY_INDEX_TEMPLATE_PATTERN = exports.SLO_SUMMARY_INDEX_TEMPLATE_NAME = exports.SLO_SUMMARY_DESTINATION_INDEX_PATTERN = exports.SLO_SUMMARY_DESTINATION_INDEX_NAME = exports.SLO_SUMMARY_COMPONENT_TEMPLATE_SETTINGS_NAME = exports.SLO_SUMMARY_COMPONENT_TEMPLATE_MAPPINGS_NAME = exports.SLO_RESOURCES_VERSION = exports.SLO_MODEL_VERSION = exports.SLO_INGEST_PIPELINE_NAME = exports.SLO_INGEST_PIPELINE_INDEX_NAME_PREFIX = exports.SLO_INDEX_TEMPLATE_PATTERN = exports.SLO_INDEX_TEMPLATE_NAME = exports.SLO_DESTINATION_INDEX_PATTERN = exports.SLO_DESTINATION_INDEX_NAME = exports.SLO_COMPONENT_TEMPLATE_SETTINGS_NAME = exports.SLO_COMPONENT_TEMPLATE_MAPPINGS_NAME = exports.DEFAULT_SLO_PAGE_SIZE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SLO_MODEL_VERSION = 2;
exports.SLO_MODEL_VERSION = SLO_MODEL_VERSION;
const SLO_RESOURCES_VERSION = 3;
exports.SLO_RESOURCES_VERSION = SLO_RESOURCES_VERSION;
const SLO_COMPONENT_TEMPLATE_MAPPINGS_NAME = '.slo-observability.sli-mappings';
exports.SLO_COMPONENT_TEMPLATE_MAPPINGS_NAME = SLO_COMPONENT_TEMPLATE_MAPPINGS_NAME;
const SLO_COMPONENT_TEMPLATE_SETTINGS_NAME = '.slo-observability.sli-settings';
exports.SLO_COMPONENT_TEMPLATE_SETTINGS_NAME = SLO_COMPONENT_TEMPLATE_SETTINGS_NAME;
const SLO_INDEX_TEMPLATE_NAME = '.slo-observability.sli';
exports.SLO_INDEX_TEMPLATE_NAME = SLO_INDEX_TEMPLATE_NAME;
const SLO_INDEX_TEMPLATE_PATTERN = `.slo-observability.sli-*`;
exports.SLO_INDEX_TEMPLATE_PATTERN = SLO_INDEX_TEMPLATE_PATTERN;
const SLO_DESTINATION_INDEX_NAME = `.slo-observability.sli-v${SLO_RESOURCES_VERSION}`;
exports.SLO_DESTINATION_INDEX_NAME = SLO_DESTINATION_INDEX_NAME;
const SLO_DESTINATION_INDEX_PATTERN = `.slo-observability.sli-v${SLO_RESOURCES_VERSION}*`;
exports.SLO_DESTINATION_INDEX_PATTERN = SLO_DESTINATION_INDEX_PATTERN;
const SLO_INGEST_PIPELINE_NAME = `.slo-observability.sli.pipeline-v${SLO_RESOURCES_VERSION}`;
exports.SLO_INGEST_PIPELINE_NAME = SLO_INGEST_PIPELINE_NAME;
const SLO_INGEST_PIPELINE_INDEX_NAME_PREFIX = `.slo-observability.sli-v${SLO_RESOURCES_VERSION}.`;
exports.SLO_INGEST_PIPELINE_INDEX_NAME_PREFIX = SLO_INGEST_PIPELINE_INDEX_NAME_PREFIX;
const SLO_SUMMARY_COMPONENT_TEMPLATE_MAPPINGS_NAME = '.slo-observability.summary-mappings';
exports.SLO_SUMMARY_COMPONENT_TEMPLATE_MAPPINGS_NAME = SLO_SUMMARY_COMPONENT_TEMPLATE_MAPPINGS_NAME;
const SLO_SUMMARY_COMPONENT_TEMPLATE_SETTINGS_NAME = '.slo-observability.summary-settings';
exports.SLO_SUMMARY_COMPONENT_TEMPLATE_SETTINGS_NAME = SLO_SUMMARY_COMPONENT_TEMPLATE_SETTINGS_NAME;
const SLO_SUMMARY_INDEX_TEMPLATE_NAME = '.slo-observability.summary';
exports.SLO_SUMMARY_INDEX_TEMPLATE_NAME = SLO_SUMMARY_INDEX_TEMPLATE_NAME;
const SLO_SUMMARY_INDEX_TEMPLATE_PATTERN = `.slo-observability.summary-*`;
exports.SLO_SUMMARY_INDEX_TEMPLATE_PATTERN = SLO_SUMMARY_INDEX_TEMPLATE_PATTERN;
const SLO_SUMMARY_DESTINATION_INDEX_NAME = `.slo-observability.summary-v${SLO_RESOURCES_VERSION}`; // store the temporary summary document generated by transform
exports.SLO_SUMMARY_DESTINATION_INDEX_NAME = SLO_SUMMARY_DESTINATION_INDEX_NAME;
const SLO_SUMMARY_TEMP_INDEX_NAME = `.slo-observability.summary-v${SLO_RESOURCES_VERSION}.temp`; // store the temporary summary document
exports.SLO_SUMMARY_TEMP_INDEX_NAME = SLO_SUMMARY_TEMP_INDEX_NAME;
const SLO_SUMMARY_DESTINATION_INDEX_PATTERN = `.slo-observability.summary-v${SLO_RESOURCES_VERSION}*`; // include temp and non-temp summary indices
exports.SLO_SUMMARY_DESTINATION_INDEX_PATTERN = SLO_SUMMARY_DESTINATION_INDEX_PATTERN;
const getSLOTransformId = (sloId, sloRevision) => `slo-${sloId}-${sloRevision}`;
exports.getSLOTransformId = getSLOTransformId;
const DEFAULT_SLO_PAGE_SIZE = 25;
exports.DEFAULT_SLO_PAGE_SIZE = DEFAULT_SLO_PAGE_SIZE;
const getSLOSummaryTransformId = (sloId, sloRevision) => `slo-summary-${sloId}-${sloRevision}`;
exports.getSLOSummaryTransformId = getSLOSummaryTransformId;
const getSLOSummaryPipelineId = (sloId, sloRevision) => `.slo-observability.summary.pipeline-${sloId}-${sloRevision}`;
exports.getSLOSummaryPipelineId = getSLOSummaryPipelineId;