"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.relativePaths = exports.paths = exports.SLO_EDIT_PATH = exports.SLO_DETAIL_PATH = exports.SLO_CREATE_PATH = exports.SLOS_WELCOME_PATH = exports.SLOS_PATH = exports.SLOS_OUTDATED_DEFINITIONS_PATH = exports.RULE_DETAIL_PATH = exports.RULES_PATH = exports.RULES_LOGS_PATH = exports.ROOT_PATH = exports.OVERVIEW_PATH = exports.OBSERVABILITY_BASE_PATH = exports.LANDING_PATH = exports.EXPLORATORY_VIEW_PATH = exports.CASES_PATH = exports.ALERT_DETAIL_PATH = exports.ALERTS_PATH = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OBSERVABILITY_BASE_PATH = '/app/observability';
exports.OBSERVABILITY_BASE_PATH = OBSERVABILITY_BASE_PATH;
const ROOT_PATH = '/';
exports.ROOT_PATH = ROOT_PATH;
const LANDING_PATH = '/landing';
exports.LANDING_PATH = LANDING_PATH;
const OVERVIEW_PATH = '/overview';
exports.OVERVIEW_PATH = OVERVIEW_PATH;
const ALERTS_PATH = '/alerts';
exports.ALERTS_PATH = ALERTS_PATH;
const ALERT_DETAIL_PATH = '/alerts/:alertId';
exports.ALERT_DETAIL_PATH = ALERT_DETAIL_PATH;
const EXPLORATORY_VIEW_PATH = '/exploratory-view'; // has been moved to its own app. Keeping around for redirecting purposes.
exports.EXPLORATORY_VIEW_PATH = EXPLORATORY_VIEW_PATH;
const RULES_PATH = '/alerts/rules';
exports.RULES_PATH = RULES_PATH;
const RULES_LOGS_PATH = '/alerts/rules/logs';
exports.RULES_LOGS_PATH = RULES_LOGS_PATH;
const RULE_DETAIL_PATH = '/alerts/rules/:ruleId';
exports.RULE_DETAIL_PATH = RULE_DETAIL_PATH;
const SLOS_PATH = '/slos';
exports.SLOS_PATH = SLOS_PATH;
const SLOS_WELCOME_PATH = '/slos/welcome';
exports.SLOS_WELCOME_PATH = SLOS_WELCOME_PATH;
const SLO_DETAIL_PATH = '/slos/:sloId';
exports.SLO_DETAIL_PATH = SLO_DETAIL_PATH;
const SLO_CREATE_PATH = '/slos/create';
exports.SLO_CREATE_PATH = SLO_CREATE_PATH;
const SLO_EDIT_PATH = '/slos/edit/:sloId';
exports.SLO_EDIT_PATH = SLO_EDIT_PATH;
const SLOS_OUTDATED_DEFINITIONS_PATH = '/slos/outdated-definitions';
exports.SLOS_OUTDATED_DEFINITIONS_PATH = SLOS_OUTDATED_DEFINITIONS_PATH;
const CASES_PATH = '/cases';
exports.CASES_PATH = CASES_PATH;
const paths = {
  observability: {
    alerts: `${OBSERVABILITY_BASE_PATH}${ALERTS_PATH}`,
    alertDetails: alertId => `${OBSERVABILITY_BASE_PATH}${ALERTS_PATH}/${encodeURI(alertId)}`,
    rules: `${OBSERVABILITY_BASE_PATH}${RULES_PATH}`,
    ruleDetails: ruleId => `${OBSERVABILITY_BASE_PATH}${RULES_PATH}/${encodeURI(ruleId)}`,
    slos: `${OBSERVABILITY_BASE_PATH}${SLOS_PATH}`,
    slosWelcome: `${OBSERVABILITY_BASE_PATH}${SLOS_WELCOME_PATH}`,
    slosOutdatedDefinitions: `${OBSERVABILITY_BASE_PATH}${SLOS_OUTDATED_DEFINITIONS_PATH}`,
    sloCreate: `${OBSERVABILITY_BASE_PATH}${SLO_CREATE_PATH}`,
    sloCreateWithEncodedForm: encodedParams => `${OBSERVABILITY_BASE_PATH}${SLO_CREATE_PATH}?_a=${encodedParams}`,
    sloEdit: sloId => `${OBSERVABILITY_BASE_PATH}${SLOS_PATH}/edit/${encodeURI(sloId)}`,
    sloEditWithEncodedForm: (sloId, encodedParams) => `${OBSERVABILITY_BASE_PATH}${SLOS_PATH}/edit/${encodeURI(sloId)}?_a=${encodedParams}`,
    sloDetails: (sloId, instanceId) => !!instanceId ? `${OBSERVABILITY_BASE_PATH}${SLOS_PATH}/${encodeURI(sloId)}?instanceId=${encodeURI(instanceId)}` : `${OBSERVABILITY_BASE_PATH}${SLOS_PATH}/${encodeURI(sloId)}`
  }
};
exports.paths = paths;
const relativePaths = {
  observability: {
    ruleDetails: ruleId => `${RULES_PATH}/${encodeURI(ruleId)}`
  }
};
exports.relativePaths = relativePaths;