"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsLocatorDefinition = exports.ALERTS_PATH = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _queryString = require("query-string");
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _common = require("@kbn/kibana-utils-plugin/common");
var _common2 = require("@kbn/spaces-plugin/common");
var _ = require("..");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_PATH = '/app/observability/alerts';
exports.ALERTS_PATH = ALERTS_PATH;
function fromQuery(query) {
  const encodedQuery = _common.url.encodeQuery(query, value => encodeURIComponent(value).replace(/%3A/g, ':'));
  return (0, _queryString.stringify)(encodedQuery, {
    sort: false,
    encode: false
  });
}
class AlertsLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _.alertsLocatorID);
    (0, _defineProperty2.default)(this, "getLocation", async ({
      baseUrl,
      spaceId,
      kuery,
      rangeTo,
      rangeFrom,
      status
    }) => {
      const appState = {};
      appState.rangeFrom = rangeFrom || 'now-15m';
      appState.rangeTo = rangeTo || 'now';
      appState.kuery = kuery || '';
      appState.status = status || 'all';
      const path = (0, _common2.addSpaceIdToPath)(baseUrl, spaceId, ALERTS_PATH);
      const url = new URL(path);
      url.search = fromQuery({
        [_constants.ALERTS_URL_STORAGE_KEY]: _rison.default.encodeUnknown(appState)
      });
      return {
        app: 'observability',
        path: url.href,
        state: {}
      };
    });
  }
}
exports.AlertsLocatorDefinition = AlertsLocatorDefinition;