"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggType = exports.ThresholdFormatterTypeRT = exports.QUERY_INVALID = exports.MetricsExplorerChartType = exports.InfraFormatterType = exports.Comparator = exports.AlertStates = exports.Aggregators = void 0;
exports.fromEnum = fromEnum;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ThresholdFormatterTypeRT = rt.keyof({
  abbreviatedNumber: null,
  bits: null,
  bytes: null,
  number: null,
  percent: null,
  highPrecision: null
});
exports.ThresholdFormatterTypeRT = ThresholdFormatterTypeRT;
let Comparator;
exports.Comparator = Comparator;
(function (Comparator) {
  Comparator["GT"] = ">";
  Comparator["LT"] = "<";
  Comparator["GT_OR_EQ"] = ">=";
  Comparator["LT_OR_EQ"] = "<=";
  Comparator["BETWEEN"] = "between";
  Comparator["OUTSIDE_RANGE"] = "outside";
})(Comparator || (exports.Comparator = Comparator = {}));
let Aggregators;
exports.Aggregators = Aggregators;
(function (Aggregators) {
  Aggregators["COUNT"] = "count";
  Aggregators["AVERAGE"] = "avg";
  Aggregators["SUM"] = "sum";
  Aggregators["MIN"] = "min";
  Aggregators["MAX"] = "max";
  Aggregators["CARDINALITY"] = "cardinality";
})(Aggregators || (exports.Aggregators = Aggregators = {}));
const aggType = fromEnum('Aggregators', Aggregators);
exports.aggType = aggType;
let MetricsExplorerChartType;
exports.MetricsExplorerChartType = MetricsExplorerChartType;
(function (MetricsExplorerChartType) {
  MetricsExplorerChartType["line"] = "line";
  MetricsExplorerChartType["area"] = "area";
  MetricsExplorerChartType["bar"] = "bar";
})(MetricsExplorerChartType || (exports.MetricsExplorerChartType = MetricsExplorerChartType = {}));
let AlertStates; // Types for the executor
exports.AlertStates = AlertStates;
(function (AlertStates) {
  AlertStates[AlertStates["OK"] = 0] = "OK";
  AlertStates[AlertStates["ALERT"] = 1] = "ALERT";
  AlertStates[AlertStates["WARNING"] = 2] = "WARNING";
  AlertStates[AlertStates["NO_DATA"] = 3] = "NO_DATA";
  AlertStates[AlertStates["ERROR"] = 4] = "ERROR";
})(AlertStates || (exports.AlertStates = AlertStates = {}));
const QUERY_INVALID = Symbol('QUERY_INVALID');
exports.QUERY_INVALID = QUERY_INVALID;
let InfraFormatterType;
/*
 * Utils
 *
 * This utility function can be used to turn a TypeScript enum into a io-ts codec.
 */
exports.InfraFormatterType = InfraFormatterType;
(function (InfraFormatterType) {
  InfraFormatterType["number"] = "number";
  InfraFormatterType["abbreviatedNumber"] = "abbreviatedNumber";
  InfraFormatterType["bytes"] = "bytes";
  InfraFormatterType["bits"] = "bits";
  InfraFormatterType["percent"] = "percent";
})(InfraFormatterType || (exports.InfraFormatterType = InfraFormatterType = {}));
function fromEnum(enumName, theEnum) {
  const isEnumValue = input => Object.values(theEnum).includes(input);
  return new rt.Type(enumName, isEnumValue, (input, context) => isEnumValue(input) ? rt.success(input) : rt.failure(input, context), rt.identity);
}