"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getViewInAppUrl = void 0;
var _observabilityGetPaddedAlertTimeRangeUtil = require("@kbn/observability-get-padded-alert-time-range-util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getViewInAppUrl = (metrics, startedAt, logExplorerLocator, filter, dataViewId, endedAt) => {
  if (!logExplorerLocator) return '';
  let timeRange;
  if (startedAt) {
    timeRange = (0, _observabilityGetPaddedAlertTimeRangeUtil.getPaddedAlertTimeRange)(startedAt, endedAt);
    timeRange.to = endedAt ? timeRange.to : 'now';
  }
  const query = {
    query: '',
    language: 'kuery'
  };
  const isOneCountConditionWithFilter = metrics.length === 1 && metrics[0].aggType === 'count' && metrics[0].filter;
  if (filter && isOneCountConditionWithFilter) {
    query.query = `${filter} and ${metrics[0].filter}`;
  } else if (isOneCountConditionWithFilter) {
    query.query = metrics[0].filter;
  } else if (filter) {
    query.query = filter;
  }
  return logExplorerLocator === null || logExplorerLocator === void 0 ? void 0 : logExplorerLocator.getRedirectUrl({
    dataset: dataViewId,
    timeRange,
    query
  });
};
exports.getViewInAppUrl = getViewInAppUrl;