"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logsOnboardingRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _create_observability_onboarding_server_route = require("../create_observability_onboarding_server_route");
var _get_fallback_urls = require("../../lib/get_fallback_urls");
var _has_log_monitoring_privileges = require("./api_key/has_log_monitoring_privileges");
var _state = require("../../lib/state");
var _create_shipper_api_key = require("./api_key/create_shipper_api_key");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logMonitoringPrivilegesRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'GET /internal/observability_onboarding/logs/setup/privileges',
  options: {
    tags: []
  },
  handler: async resources => {
    const {
      context
    } = resources;
    const {
      elasticsearch: {
        client
      }
    } = await context.core;
    const hasPrivileges = await (0, _has_log_monitoring_privileges.hasLogMonitoringPrivileges)(client.asCurrentUser);
    return {
      hasPrivileges
    };
  }
});
const installShipperSetupRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'GET /internal/observability_onboarding/logs/setup/environment',
  options: {
    tags: []
  },
  async handler(resources) {
    var _ref, _core$setup$http$base, _plugins$cloud, _plugins$cloud$setup;
    const {
      core,
      plugins,
      kibanaVersion
    } = resources;
    const coreStart = await core.start();
    const fleetPluginStart = await plugins.fleet.start();
    const agentClient = fleetPluginStart.agentService.asInternalUser;

    // If undefined, we will follow fleet's strategy to select latest available version:
    // for serverless we will use the latest published version, for statefull we will use
    // current Kibana version. If false, irrespective of fleet flags and logic, we are
    // explicitly deciding to not append the current version.
    const includeCurrentVersion = kibanaVersion.endsWith('-SNAPSHOT') ? false : undefined;
    const elasticAgentVersion = await agentClient.getLatestAgentAvailableVersion(includeCurrentVersion);
    const kibanaUrl = (_ref = (_core$setup$http$base = core.setup.http.basePath.publicBaseUrl) !== null && _core$setup$http$base !== void 0 ? _core$setup$http$base : // priority given to server.publicBaseUrl
    (_plugins$cloud = plugins.cloud) === null || _plugins$cloud === void 0 ? void 0 : (_plugins$cloud$setup = _plugins$cloud.setup) === null || _plugins$cloud$setup === void 0 ? void 0 : _plugins$cloud$setup.kibanaUrl) !== null && _ref !== void 0 ? _ref :
    // then cloud id
    (0, _get_fallback_urls.getFallbackKibanaUrl)(coreStart); // falls back to local network binding
    const scriptDownloadUrl = `${kibanaUrl}/plugins/observabilityOnboarding/assets/standalone_agent_setup.sh`;
    const apiEndpoint = `${kibanaUrl}/internal/observability_onboarding`;
    return {
      apiEndpoint,
      scriptDownloadUrl,
      elasticAgentVersion
    };
  }
});
const createFlowRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'POST /internal/observability_onboarding/logs/flow',
  options: {
    tags: []
  },
  params: t.type({
    body: t.intersection([t.type({
      name: t.string
    }), t.type({
      type: t.union([t.literal('logFiles'), t.literal('systemLogs')])
    }), t.partial({
      state: t.record(t.string, t.unknown)
    })])
  }),
  async handler(resources) {
    const {
      context,
      params: {
        body: {
          name,
          type,
          state
        }
      },
      core,
      request
    } = resources;
    const coreStart = await core.start();
    const {
      elasticsearch: {
        client
      }
    } = await context.core;
    const {
      encoded: apiKeyEncoded
    } = await (0, _create_shipper_api_key.createShipperApiKey)(client.asCurrentUser, name);
    const generatedState = type === 'systemLogs' ? {
      namespace: 'default'
    } : state;
    const savedObjectsClient = coreStart.savedObjects.getScopedClient(request);
    const {
      id
    } = await (0, _state.saveObservabilityOnboardingFlow)({
      savedObjectsClient,
      observabilityOnboardingState: {
        type,
        state: generatedState,
        progress: {}
      }
    });
    return {
      apiKeyEncoded,
      onboardingId: id
    };
  }
});
const logsOnboardingRouteRepository = {
  ...logMonitoringPrivilegesRoute,
  ...installShipperSetupRoute,
  ...createFlowRoute
};
exports.logsOnboardingRouteRepository = logsOnboardingRouteRepository;