"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.elasticAgentRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _uuid = require("uuid");
var _elastic_agent_logs = require("../../../common/elastic_agent_logs");
var _get_authentication_api_key = require("../../lib/get_authentication_api_key");
var _get_fallback_urls = require("../../lib/get_fallback_urls");
var _state = require("../../lib/state");
var _create_observability_onboarding_server_route = require("../create_observability_onboarding_server_route");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateConfig = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'GET /internal/observability_onboarding/elastic_agent/config',
  params: t.type({
    query: t.type({
      onboardingId: t.string
    })
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    var _plugins$cloud, _plugins$cloud$setup, _plugins$cloud2, _plugins$cloud2$setup;
    const {
      params: {
        query: {
          onboardingId
        }
      },
      core,
      plugins,
      request,
      services: {
        esLegacyConfigService
      }
    } = resources;
    const authApiKey = (0, _get_authentication_api_key.getAuthenticationAPIKey)(request);
    const coreStart = await core.start();
    const savedObjectsClient = coreStart.savedObjects.createInternalRepository();
    const elasticsearchUrl = (_plugins$cloud = plugins.cloud) !== null && _plugins$cloud !== void 0 && (_plugins$cloud$setup = _plugins$cloud.setup) !== null && _plugins$cloud$setup !== void 0 && _plugins$cloud$setup.elasticsearchUrl ? [(_plugins$cloud2 = plugins.cloud) === null || _plugins$cloud2 === void 0 ? void 0 : (_plugins$cloud2$setup = _plugins$cloud2.setup) === null || _plugins$cloud2$setup === void 0 ? void 0 : _plugins$cloud2$setup.elasticsearchUrl] : await (0, _get_fallback_urls.getFallbackESUrl)(esLegacyConfigService);
    const savedState = await (0, _state.getObservabilityOnboardingFlow)({
      savedObjectsClient,
      savedObjectId: onboardingId
    });
    const yaml = (savedState === null || savedState === void 0 ? void 0 : savedState.type) === 'systemLogs' ? (0, _elastic_agent_logs.generateSystemLogsYml)({
      ...(savedState === null || savedState === void 0 ? void 0 : savedState.state),
      apiKey: authApiKey ? `${authApiKey === null || authApiKey === void 0 ? void 0 : authApiKey.apiKeyId}:${authApiKey === null || authApiKey === void 0 ? void 0 : authApiKey.apiKey}` : '$API_KEY',
      esHost: elasticsearchUrl,
      uuid: (0, _uuid.v4)()
    }) : (0, _elastic_agent_logs.generateCustomLogsYml)({
      ...(savedState === null || savedState === void 0 ? void 0 : savedState.state),
      apiKey: authApiKey ? `${authApiKey === null || authApiKey === void 0 ? void 0 : authApiKey.apiKeyId}:${authApiKey === null || authApiKey === void 0 ? void 0 : authApiKey.apiKey}` : '$API_KEY',
      esHost: elasticsearchUrl,
      logfileId: `custom-logs-${(0, _uuid.v4)()}`
    });
    return yaml;
  }
});
const elasticAgentRouteRepository = {
  ...generateConfig
};
exports.elasticAgentRouteRepository = elasticAgentRouteRepository;