"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.callObservabilityOnboardingApi = void 0;
exports.createCallApi = createCallApi;
var _serverRouteRepository = require("@kbn/server-route-repository");
var _call_api = require("./call_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let callObservabilityOnboardingApi = () => {
  throw new Error('callObservabilityOnboardingApi has to be initialized before used. Call createCallApi first.');
};
exports.callObservabilityOnboardingApi = callObservabilityOnboardingApi;
function createCallApi(core) {
  exports.callObservabilityOnboardingApi = callObservabilityOnboardingApi = (endpoint, options) => {
    const {
      params
    } = options;
    const {
      method,
      pathname
    } = (0, _serverRouteRepository.formatRequest)(endpoint, params === null || params === void 0 ? void 0 : params.path);
    return (0, _call_api.callApi)(core, {
      ...options,
      method,
      pathname,
      body: params === null || params === void 0 ? void 0 : params.body,
      query: params === null || params === void 0 ? void 0 : params.query
    });
  };
}