"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.noBreadcrumbs = void 0;
exports.setBreadcrumbs = setBreadcrumbs;
exports.useBreadcrumbs = void 0;
var _react = require("react");
var _translations = require("../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBreadcrumbs = (breadcrumbs, chromeService, serverlessService) => {
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs, chromeService, serverlessService);
  }, [breadcrumbs, chromeService, serverlessService]);
};
exports.useBreadcrumbs = useBreadcrumbs;
function setBreadcrumbs(breadcrumbs, chromeService, serverlessService) {
  if (serverlessService) {
    serverlessService.setBreadcrumbs(breadcrumbs);
  } else if (chromeService) {
    chromeService.setBreadcrumbs([{
      text: _translations.logExplorerAppTitle
    }, ...breadcrumbs]);
  }
}
const noBreadcrumbs = [];
exports.noBreadcrumbs = noBreadcrumbs;