"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRequestFeedbackNotifier = void 0;
var _coreMountUtilsBrowserInternal = require("@kbn/core-mount-utils-browser-internal");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-shared-plugin/common");
var _react = _interopRequireDefault(require("react"));
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createRequestFeedbackNotifier = toasts => () => {
  toasts.addInfo({
    title: _i18n.i18n.translate('xpack.observabilityLogExplorer.feedbackToast.title', {
      defaultMessage: 'Tell us what you think!'
    }),
    text: (0, _coreMountUtilsBrowserInternal.mountReactNode)( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observabilityLogExplorer.feedbackToast.text', {
      defaultMessage: 'Share with us your onboarding experience and help us improve it.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "observabilityLogExplorerFeedbackToastButton",
      href: _common.LOGS_ONBOARDING_FEEDBACK_LINK,
      size: "s",
      target: "_blank",
      color: "primary"
    }, _i18n.i18n.translate('xpack.observabilityLogExplorer.feedbackToast.buttonText', {
      defaultMessage: 'Take a quick survey'
    })))))),
    iconType: 'editorComment'
  }, {
    toastLifeTimeMs: _constants.FEEDBACK_TOAST_LIFETIME_MS
  });
};
exports.createRequestFeedbackNotifier = createRequestFeedbackNotifier;