"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogExplorerTopNavMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _public = require("@kbn/observability-shared-plugin/public");
var _eui = require("@elastic/eui");
var _locators = require("@kbn/deeplinks-observability/locators");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react2 = require("@emotion/react");
var _common = require("@kbn/observability-shared-plugin/common");
var _uiTheme = require("@kbn/ui-theme");
var _translations = require("../../common/translations");
var _get_router_link_props = require("../utils/get_router_link_props");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogExplorerTopNavMenu = ({
  setHeaderActionMenu,
  services,
  state$,
  theme$
}) => {
  const {
    serverless
  } = services;
  return Boolean(serverless) ? /*#__PURE__*/_react.default.createElement(ServerlessTopNav, {
    services: services,
    state$: state$
  }) : /*#__PURE__*/_react.default.createElement(StatefulTopNav, {
    services: services,
    setHeaderActionMenu: setHeaderActionMenu,
    state$: state$,
    theme$: theme$
  });
};
exports.LogExplorerTopNavMenu = LogExplorerTopNavMenu;
const ServerlessTopNav = ({
  services,
  state$
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeader, {
    "data-test-subj": "logExplorerHeaderMenu"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(DiscoverLink, {
    services: services,
    state$: state$
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSection, {
    side: "right",
    css: (0, _react2.css)`
          gap: ${_uiTheme.euiThemeVars.euiSizeM};
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    size: "s",
    iconType: "beta",
    label: _translations.betaBadgeTitle,
    tooltipContent: _translations.betaBadgeDescription,
    alignment: "middle"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(FeedbackLink, null), /*#__PURE__*/_react.default.createElement(VerticalRule, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(OnboardingLink, {
    services: services
  }))));
};
const StatefulTopNav = ({
  setHeaderActionMenu,
  services,
  state$,
  theme$
}) => {
  /**
   * Since the breadcrumbsAppendExtension might be set only during a plugin start (e.g. search session)
   * we retrieve the latest valid extension in order to restore it once we unmount the beta badge.
   */
  const [previousAppendExtension$] = (0, _react.useState)(() => services.chrome.getBreadcrumbsAppendExtension$().pipe((0, _rxjs.filter)(Boolean), (0, _rxjs.take)(1)));
  const previousAppendExtension = (0, _useObservable.default)(previousAppendExtension$);
  (0, _react.useEffect)(() => {
    const {
      chrome,
      i18n,
      theme
    } = services;
    if (chrome) {
      chrome.setBreadcrumbsAppendExtension({
        content: (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSection, {
          "data-test-subj": "logExplorerHeaderMenu",
          css: (0, _react2.css)`
              margin-left: ${_uiTheme.euiThemeVars.euiSizeM};
            `
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
          size: "s",
          iconType: "beta",
          label: _translations.betaBadgeTitle,
          tooltipContent: _translations.betaBadgeDescription,
          alignment: "middle"
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(FeedbackLink, null))), {
          theme,
          i18n
        })
      });
    }
    return () => {
      if (chrome) {
        chrome.setBreadcrumbsAppendExtension(previousAppendExtension);
      }
    };
  }, [services, previousAppendExtension]);
  return /*#__PURE__*/_react.default.createElement(_public.HeaderMenuPortal, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSection, {
    "data-test-subj": "logExplorerHeaderMenu"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(DiscoverLink, {
    services: services,
    state$: state$
  }), /*#__PURE__*/_react.default.createElement(OnboardingLink, {
    services: services
  })))));
};
const DiscoverLink = /*#__PURE__*/_react.default.memo(({
  services,
  state$
}) => {
  var _logExplorerState$dat, _services$discover$lo;
  const {
    appState,
    logExplorerState
  } = (0, _useObservable.default)(state$.pipe((0, _rxjs.distinctUntilChanged)((prev, curr) => {
    if (!prev.appState || !curr.appState) return false;
    return (0, _fastDeepEqual.default)([prev.appState.columns, prev.appState.filters, prev.appState.index, prev.appState.query], [curr.appState.columns, curr.appState.filters, curr.appState.index, curr.appState.query]);
  })), {
    appState: {},
    logExplorerState: {}
  });
  const discoverLinkParams = {
    columns: appState === null || appState === void 0 ? void 0 : appState.columns,
    filters: appState === null || appState === void 0 ? void 0 : appState.filters,
    query: appState === null || appState === void 0 ? void 0 : appState.query,
    dataViewSpec: logExplorerState === null || logExplorerState === void 0 ? void 0 : (_logExplorerState$dat = logExplorerState.datasetSelection) === null || _logExplorerState$dat === void 0 ? void 0 : _logExplorerState$dat.selection.dataset.toDataviewSpec()
  };
  const discoverUrl = (_services$discover$lo = services.discover.locator) === null || _services$discover$lo === void 0 ? void 0 : _services$discover$lo.getRedirectUrl(discoverLinkParams);
  const navigateToDiscover = () => {
    var _services$discover$lo2;
    (_services$discover$lo2 = services.discover.locator) === null || _services$discover$lo2 === void 0 ? void 0 : _services$discover$lo2.navigate(discoverLinkParams);
  };
  const discoverLinkProps = (0, _get_router_link_props.getRouterLinkProps)({
    href: discoverUrl,
    onClick: navigateToDiscover
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, (0, _extends2.default)({}, discoverLinkProps, {
    color: "primary",
    iconType: "discoverApp",
    "data-test-subj": "logExplorerDiscoverFallbackLink"
  }), _translations.discoverLinkTitle);
});
const OnboardingLink = /*#__PURE__*/_react.default.memo(({
  services
}) => {
  const locator = services.share.url.locators.get(_locators.OBSERVABILITY_ONBOARDING_LOCATOR);
  const onboardingUrl = locator === null || locator === void 0 ? void 0 : locator.useUrl({});
  const navigateToOnboarding = () => {
    locator === null || locator === void 0 ? void 0 : locator.navigate({});
  };
  const onboardingLinkProps = (0, _get_router_link_props.getRouterLinkProps)({
    href: onboardingUrl,
    onClick: navigateToOnboarding
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, onboardingLinkProps, {
    fill: true,
    size: "s",
    iconType: "indexOpen",
    "data-test-subj": "logExplorerOnboardingLink"
  }), _translations.onboardingLinkTitle);
});
const FeedbackLink = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    href: _common.LOG_EXPLORER_FEEDBACK_LINK,
    iconType: "popout",
    iconSide: "right",
    iconSize: "s",
    target: "_blank"
  }, _translations.feedbackLinkTitle);
});
const VerticalRule = _styled.default.span`
  width: 1px;
  height: 20px;
  background-color: ${_uiTheme.euiThemeVars.euiColorLightShade};
`;