"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.streamIntoObservable = streamIntoObservable;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function streamIntoObservable(readable) {
  let lineBuffer = '';
  return (0, _rxjs.from)(readable).pipe((0, _rxjs.map)(chunk => chunk.toString('utf-8')), (0, _rxjs.map)(part => {
    const lines = (lineBuffer + part).split('\n');
    lineBuffer = lines.pop() || ''; // Keep the last incomplete line for the next chunk
    return lines;
  }), (0, _rxjs.concatMap)(lines => lines), (0, _rxjs.filter)(line => line.trim() !== ''));
}