"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.splitKbText = splitKbText;
var _lodash = require("lodash");
var _knowledge_base_service = require("../knowledge_base_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function splitKbText({
  id,
  texts,
  ...rest
}) {
  return [{
    type: _knowledge_base_service.KnowledgeBaseEntryOperationType.Delete,
    doc_id: id,
    labels: {}
  }, ...texts.map((text, index) => ({
    type: _knowledge_base_service.KnowledgeBaseEntryOperationType.Index,
    document: (0, _lodash.merge)({}, rest, {
      id: [id, index].join('_'),
      doc_id: id,
      labels: {},
      text
    })
  }))];
}