"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.observabilityAIAssistantRouter = void 0;
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var t = _interopRequireWildcard(require("io-ts"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _page_template = require("../components/page_template");
var _conversation_view = require("./conversations/conversation_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The array of route definitions to be used when the application
 * creates the routes.
 */
const observabilityAIAssistantRoutes = {
  '/': {
    element: /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: "/conversations/new"
    })
  },
  '/conversations': {
    element: /*#__PURE__*/_react.default.createElement(_page_template.ObservabilityAIAssistantPageTemplate, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null)),
    children: {
      '/conversations/new': {
        element: /*#__PURE__*/_react.default.createElement(_conversation_view.ConversationView, null)
      },
      '/conversations/{conversationId}': {
        params: t.intersection([t.type({
          path: t.type({
            conversationId: t.string
          })
        }), t.partial({
          state: t.partial({
            prevConversationKey: t.string
          })
        })]),
        element: /*#__PURE__*/_react.default.createElement(_conversation_view.ConversationView, null)
      },
      '/conversations': {
        element: /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: "/conversations/new"
        })
      }
    }
  }
};
const observabilityAIAssistantRouter = (0, _typedReactRouterConfig.createRouter)(observabilityAIAssistantRoutes);
exports.observabilityAIAssistantRouter = observabilityAIAssistantRouter;