"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLicense = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _use_observability_ai_assistant = require("./use_observability_ai_assistant");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLicense = () => {
  var _service$getLicense;
  const service = (0, _use_observability_ai_assistant.useObservabilityAIAssistant)();
  const license = (0, _useObservable.default)((_service$getLicense = service.getLicense()) !== null && _service$getLicense !== void 0 ? _service$getLicense : new _rxjs.Observable(), null);
  return {
    getLicense: () => license,
    hasAtLeast: (0, _react.useCallback)(level => {
      if (!license) return;
      return !!license && license.isAvailable && license.isActive && license.hasAtLeast(level);
    }, [license])
  };
};
exports.useLicense = useLicense;