"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useJsonEditorModel = void 0;
var _react = require("react");
var _monaco = require("@kbn/monaco");
var _create_initialized_object = require("../utils/create_initialized_object");
var _use_observability_ai_assistant_chat_service = require("./use_observability_ai_assistant_chat_service");
var _safe_json_parse = require("../utils/safe_json_parse");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  editor,
  languages,
  Uri
} = _monaco.monaco;
const useJsonEditorModel = ({
  functionName,
  initialJson
}) => {
  const chatService = (0, _use_observability_ai_assistant_chat_service.useObservabilityAIAssistantChatService)();
  const functionDefinition = chatService.getFunctions().find(func => func.name === functionName);
  const [initialJsonValue, setInitialJsonValue] = (0, _react.useState)(initialJson);
  const SCHEMA_URI = `http://elastic.co/${functionName}.json`;
  const modelUri = (0, _react.useMemo)(() => Uri.parse(SCHEMA_URI), [SCHEMA_URI]);
  (0, _react.useEffect)(() => {
    setInitialJsonValue(initialJson);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [functionName]);
  return (0, _react.useMemo)(() => {
    if (!functionDefinition || !modelUri) {
      return {};
    }
    const schema = {
      ...functionDefinition.parameters
    };
    const initialJsonString = initialJsonValue ? JSON.stringify((0, _safe_json_parse.safeJsonParse)(initialJsonValue), null, 4) // prettify the json
    : functionDefinition.parameters.properties ? JSON.stringify((0, _create_initialized_object.createInitializedObject)(functionDefinition.parameters), null, 4) : '';
    languages.json.jsonDefaults.setDiagnosticsOptions({
      validate: true,
      schemas: [{
        uri: SCHEMA_URI,
        fileMatch: [String(modelUri)],
        schema
      }]
    });
    let model = editor.getModel(modelUri);
    if (model === null) {
      model = editor.createModel(initialJsonString, 'json', modelUri);
    } else {
      model.setValue(initialJsonString);
    }
    return {
      model,
      initialJsonString
    };
  }, [SCHEMA_URI, functionDefinition, initialJsonValue, modelUri]);
};
exports.useJsonEditorModel = useJsonEditorModel;