"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InsightBase = InsightBase;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _assistant_avatar = require("../assistant_avatar");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InsightBase({
  title,
  description = _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.defaultDescription', {
    defaultMessage: 'Get helpful insights from our Elastic AI Assistant.'
  }),
  controls,
  children,
  actions,
  onToggle,
  loading,
  dataTestSubj = 'obsAiAssistantInsightButton'
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isActionsPopoverOpen, setIsActionsPopover] = (0, _react.useState)(false);
  const handleClickActions = () => {
    setIsActionsPopover(!isActionsPopoverOpen);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "obsAiAssistantInsight",
    arrowProps: {
      css: {
        alignSelf: 'flex-start'
      }
    },
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      responsive: false,
      gutterSize: "m",
      "data-test-subj": dataTestSubj
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_assistant_avatar.AssistantAvatar, {
      size: "xs"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: {
        marginTop: 2,
        marginBottom: 1
      }
    }, /*#__PURE__*/_react.default.createElement("h5", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      css: {
        color: euiTheme.colors.subduedText
      }
    }, /*#__PURE__*/_react.default.createElement("span", null, description)))),
    isLoading: loading,
    isDisabled: loading,
    extraAction: actions !== null && actions !== void 0 && actions.length || controls ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      responsive: false
    }, controls && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, controls), actions !== null && actions !== void 0 && actions.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      anchorPosition: "downLeft",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.actions', {
          defaultMessage: 'Actions'
        }),
        color: "text",
        css: {
          alignSelf: 'flex-start'
        },
        "data-test-subj": "observabilityAiAssistantInsightBaseButtonIcon",
        disabled: (actions === null || actions === void 0 ? void 0 : actions.length) === 0,
        display: "empty",
        iconType: "boxesHorizontal",
        size: "s",
        onClick: handleClickActions
      }),
      panelPaddingSize: "s",
      closePopover: handleClickActions,
      isOpen: isActionsPopoverOpen
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: actions === null || actions === void 0 ? void 0 : actions.map(({
        id,
        icon,
        label,
        handler
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: id,
        icon: icon,
        onClick: handler
      }, label))
    }))) : null) : null,
    onToggle: onToggle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    color: "subdued"
  }, children)));
}