"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WelcomeMessageKnowledgeBaseSetupErrorPanel = WelcomeMessageKnowledgeBaseSetupErrorPanel;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const panelContainerClassName = (0, _css.css)`
  width: 330px;
`;
function WelcomeMessageKnowledgeBaseSetupErrorPanel({
  knowledgeBase,
  onRetryInstall
}) {
  var _knowledgeBase$status, _knowledgeBase$status2, _knowledgeBase$status3, _knowledgeBase$status4, _knowledgeBase$status5, _knowledgeBase$status6;
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const modelName = (_knowledgeBase$status = knowledgeBase.status.value) === null || _knowledgeBase$status === void 0 ? void 0 : _knowledgeBase$status.model_name;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: panelContainerClassName,
    "data-test-subj": "observabilityAiAssistantWelcomeMessageKnowledgeBaseSetupErrorPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.observabilityAiAssistant.welcomeMessage.issuesDescriptionListTitleLabel', {
    defaultMessage: 'Issues'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement("ul", null, !((_knowledgeBase$status2 = knowledgeBase.status.value) !== null && _knowledgeBase$status2 !== void 0 && _knowledgeBase$status2.deployment_state) ? /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "alert",
    color: "subdued"
  }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observabilityAiAssistant.welcomeMessage.modelIsNotDeployedLabel",
    defaultMessage: "Model {modelName} is not deployed",
    values: {
      modelName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, modelName)
    }
  })) : null, (_knowledgeBase$status3 = knowledgeBase.status.value) !== null && _knowledgeBase$status3 !== void 0 && _knowledgeBase$status3.deployment_state && knowledgeBase.status.value.deployment_state !== 'started' ? /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "alert",
    color: "subdued"
  }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observabilityAiAssistant.welcomeMessage.modelIsNotStartedLabel",
    defaultMessage: "Deployment state of {modelName} is {deploymentState}",
    values: {
      modelName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, modelName),
      deploymentState: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, (_knowledgeBase$status4 = knowledgeBase.status.value) === null || _knowledgeBase$status4 === void 0 ? void 0 : _knowledgeBase$status4.deployment_state)
    }
  })) : null, (_knowledgeBase$status5 = knowledgeBase.status.value) !== null && _knowledgeBase$status5 !== void 0 && _knowledgeBase$status5.allocation_state && knowledgeBase.status.value.allocation_state !== 'fully_allocated' ? /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "alert",
    color: "subdued"
  }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observabilityAiAssistant.welcomeMessage.modelIsNotFullyAllocatedLabel",
    defaultMessage: "Allocation state of {modelName} is {allocationState}",
    values: {
      modelName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, modelName),
      allocationState: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, (_knowledgeBase$status6 = knowledgeBase.status.value) === null || _knowledgeBase$status6 === void 0 ? void 0 : _knowledgeBase$status6.allocation_state)
    }
  })) : null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observabilityAiAssistant.welcomeMessage.div.checkTrainedModelsToLabel",
    defaultMessage: " {retryInstallingLink} or check {trainedModelsLink} to ensure {modelName} is deployed and running.",
    values: {
      modelName,
      retryInstallingLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "observabilityAiAssistantWelcomeMessageKnowledgeBaseSetupErrorPanelRetryInstallingLink",
        onClick: onRetryInstall
      }, _i18n.i18n.translate('xpack.observabilityAiAssistant.welcomeMessageKnowledgeBaseSetupErrorPanel.retryInstallingLinkLabel', {
        defaultMessage: 'Retry install'
      })),
      trainedModelsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "observabilityAiAssistantWelcomeMessageTrainedModelsLink",
        external: true,
        href: http.basePath.prepend('/app/ml/trained_models'),
        target: "_blank"
      }, _i18n.i18n.translate('xpack.observabilityAiAssistant.welcomeMessage.trainedModelsLinkLabel', {
        defaultMessage: 'Trained Models'
      }))
    }
  }))));
}