"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTelemetryEventTypes = exports.TELEMETRY = void 0;
exports.sendEvent = sendEvent;
var _chat_feedback = require("./schemas/chat_feedback");
var _insight_feedback = require("./schemas/insight_feedback");
var _user_sent_prompt = require("./schemas/user_sent_prompt");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const schemas = [_chat_feedback.chatFeedbackEventSchema, _insight_feedback.insightFeedbackEventSchema, _user_sent_prompt.userSentPromptEventSchema];
const TELEMETRY = {
  [_chat_feedback.eventType]: _chat_feedback.eventType,
  [_insight_feedback.eventType]: _insight_feedback.eventType,
  [_user_sent_prompt.eventType]: _user_sent_prompt.eventType
};
exports.TELEMETRY = TELEMETRY;
const registerTelemetryEventTypes = analytics => {
  schemas.forEach(schema => {
    analytics.registerEventType(schema);
  });
};
exports.registerTelemetryEventTypes = registerTelemetryEventTypes;
function sendEvent(analytics, eventType) {
  analytics.reportEvent(eventType.type, eventType.payload);
}