"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processOpenAiStream = processOpenAiStream;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable max-classes-per-file*/

class TokenLimitReachedError extends Error {
  constructor() {
    super(`Token limit reached`);
  }
}
class ServerError extends Error {}
function processOpenAiStream() {
  return source => source.pipe((0, _rxjs.map)(line => line.substring(6)), (0, _rxjs.filter)(line => !!line && line !== '[DONE]'), (0, _rxjs.map)(line => JSON.parse(line)), (0, _rxjs.tap)(line => {
    if ('error' in line) {
      throw new ServerError(line.error.message);
    }
    if ('choices' in line && line.choices.length && line.choices[0].finish_reason === 'length') {
      throw new TokenLimitReachedError();
    }
  }), (0, _rxjs.filter)(line => 'object' in line && line.object === 'chat.completion.chunk'));
}