"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.concatenateOpenAiChunks = void 0;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const concatenateOpenAiChunks = () => source => source.pipe((0, _rxjs.scan)((acc, {
  choices
}) => {
  var _choices$0$delta$cont, _choices$0$delta$func, _choices$0$delta$func2, _choices$0$delta$func3, _choices$0$delta$func4;
  acc.message.content += (_choices$0$delta$cont = choices[0].delta.content) !== null && _choices$0$delta$cont !== void 0 ? _choices$0$delta$cont : '';
  acc.message.function_call.name += (_choices$0$delta$func = (_choices$0$delta$func2 = choices[0].delta.function_call) === null || _choices$0$delta$func2 === void 0 ? void 0 : _choices$0$delta$func2.name) !== null && _choices$0$delta$func !== void 0 ? _choices$0$delta$func : '';
  acc.message.function_call.arguments += (_choices$0$delta$func3 = (_choices$0$delta$func4 = choices[0].delta.function_call) === null || _choices$0$delta$func4 === void 0 ? void 0 : _choices$0$delta$func4.arguments) !== null && _choices$0$delta$func3 !== void 0 ? _choices$0$delta$func3 : '';
  return (0, _lodash.cloneDeep)(acc);
}, {
  message: {
    content: '',
    function_call: {
      name: '',
      arguments: '',
      trigger: _types.MessageRole.Assistant
    },
    role: _types.MessageRole.Assistant
  }
}));
exports.concatenateOpenAiChunks = concatenateOpenAiChunks;