"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewsfeedApiDriver = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _moment = _interopRequireDefault(require("moment"));
var Rx = _interopRequireWildcard(require("rxjs"));
var _constants = require("../../common/constants");
var _convert_items = require("./convert_items");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class NewsfeedApiDriver {
  // the date is compared to time in UTC format coming from the service

  constructor(kibanaVersion, userLanguage, fetchInterval, storage) {
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "loadedTime", (0, _moment.default)().utc());
    this.userLanguage = userLanguage;
    this.fetchInterval = fetchInterval;
    this.storage = storage;
    // The API only accepts versions in the format `X.Y.Z`, so we need to drop the `-SNAPSHOT` or any other label after it
    this.kibanaVersion = kibanaVersion.replace(/^(\d+\.\d+\.\d+).*/, '$1');
  }
  shouldFetch() {
    const lastFetchUtc = this.storage.getLastFetchTime();
    if (!lastFetchUtc) {
      return true;
    }
    const last = (0, _moment.default)(lastFetchUtc);

    // does the last fetch time precede the time that the page was loaded?
    if (this.loadedTime.diff(last) > 0) {
      return true;
    }
    const now = _moment.default.utc(); // always use UTC to compare timestamps that came from the service
    const duration = _moment.default.duration(now.diff(last));
    return duration.asMilliseconds() > this.fetchInterval;
  }
  fetchNewsfeedItems(config) {
    const urlPath = config.pathTemplate.replace('{VERSION}', this.kibanaVersion);
    const fullUrl = (config.urlRoot || _constants.NEWSFEED_DEFAULT_SERVICE_BASE_URL) + urlPath;
    const request = new Request(fullUrl, {
      method: 'GET'
    });
    return Rx.from(window.fetch(request).then(async response => {
      const {
        items
      } = await response.json();
      return this.convertResponse(items);
    }));
  }
  convertResponse(items) {
    const feedItems = (0, _convert_items.convertItems)(items, this.userLanguage);
    const hasNew = this.storage.setFetchedItems(feedItems.map(item => item.hash));
    return {
      error: null,
      kibanaVersion: this.kibanaVersion,
      hasNew,
      feedItems
    };
  }
}
exports.NewsfeedApiDriver = NewsfeedApiDriver;