"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNavMenuItem = TopNavMenuItem;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function TopNavMenuItem(props) {
  function isDisabled() {
    const val = (0, _lodash.isFunction)(props.disableButton) ? props.disableButton() : props.disableButton;
    return val;
  }
  function getTooltip() {
    const val = (0, _lodash.isFunction)(props.tooltip) ? props.tooltip() : props.tooltip;
    return val;
  }
  function getButtonContainer() {
    if (props.badge) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, (0, _extends2.default)({
        className: "kbnTopNavMenu__betaBadgeItem"
      }, props.badge, {
        size: "s"
      })), (0, _lodash.upperFirst)(props.label || props.id));
    } else {
      return (0, _lodash.upperFirst)(props.label || props.id);
    }
  }
  function handleClick(e) {
    if (isDisabled()) return;
    props.run(e.currentTarget);
  }
  const commonButtonProps = {
    isDisabled: isDisabled(),
    onClick: handleClick,
    isLoading: props.isLoading,
    iconType: props.iconType,
    iconSide: props.iconSide,
    'data-test-subj': props.testId,
    className: props.className
  };

  // If the item specified a href, then override the suppress the onClick
  // and make it become a regular link
  const overrideProps = props.target && props.href ? {
    onClick: undefined,
    href: props.href,
    target: props.target
  } : {};
  const btn = props.emphasize ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    size: "s"
  }, commonButtonProps, {
    fill: true
  }), getButtonContainer()) : /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, (0, _extends2.default)({
    size: "s",
    color: "primary"
  }, commonButtonProps, overrideProps), getButtonContainer());
  const tooltip = getTooltip();
  if (tooltip) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: tooltip
    }, btn);
  }
  return btn;
}
TopNavMenuItem.defaultProps = {
  disableButton: false,
  tooltip: ''
};