"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WrappedSetupModeRenderer = exports.SetupModeRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _global_state_context = require("../../application/contexts/global_state_context");
var _use_request_error_handler = require("../../application/hooks/use_request_error_handler");
var _setup_mode = require("../../lib/setup_mode");
var _flyout = require("../metricbeat_migration/flyout");
var _exit_button = require("../setup_mode/exit_button");
var _find_new_uuid = require("./lib/find_new_uuid");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class WrappedSetupModeRenderer extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "globalState", void 0);
    (0, _defineProperty2.default)(this, "state", {
      renderState: false,
      isFlyoutOpen: false,
      instance: null,
      newProduct: null,
      isSettingUpNew: false
    });
  }
  UNSAFE_componentWillMount() {
    this.globalState = this.context;
    const {
      kibana,
      onHttpError
    } = this.props;
    (0, _setup_mode.markSetupModeSupported)();
    (0, _setup_mode.initSetupModeState)(this.globalState, kibana.services.http, onHttpError, _oldData => {
      const newState = {
        renderState: true
      };
      const {
        productName
      } = this.props;
      if (!productName) {
        this.setState(newState);
        return;
      }
      const setupModeState = (0, _setup_mode.getSetupModeState)();
      if (!setupModeState.enabled || !setupModeState.data) {
        this.setState(newState);
        return;
      }
      const data = setupModeState.data[productName];
      const oldData = _oldData ? _oldData[productName] : null;
      if (data && oldData) {
        const newUuid = (0, _find_new_uuid.findNewUuid)(Object.keys(oldData.byUuid), Object.keys(data.byUuid));
        if (newUuid) {
          newState.newProduct = data.byUuid[newUuid];
        }
      }
      this.setState(newState);
    });
  }
  componentWillUnmount() {
    (0, _setup_mode.markSetupModeUnsupported)();
  }
  reset() {
    this.setState({
      renderState: false,
      isFlyoutOpen: false,
      instance: null,
      newProduct: null,
      isSettingUpNew: false
    });
  }
  getFlyout(data, meta) {
    const {
      productName
    } = this.props;
    const {
      isFlyoutOpen,
      instance,
      isSettingUpNew,
      newProduct
    } = this.state;
    if (!data || !isFlyoutOpen) {
      return null;
    }
    let product = null;
    if (newProduct) {
      product = newProduct;
    }
    // For new instance discovery flow, we pass in empty instance object
    else if (instance && Object.keys(instance).length) {
      product = data.byUuid[instance.uuid];
    }
    if (!product) {
      const uuids = Object.values(data.byUuid);
      if (uuids.length && !isSettingUpNew) {
        product = uuids[0];
      } else {
        product = {
          isNetNewUser: true
        };
      }
    }
    return /*#__PURE__*/_react.default.createElement(_flyout.Flyout, {
      onClose: () => this.reset(),
      productName: productName,
      product: product,
      meta: meta,
      instance: instance,
      updateProduct: _setup_mode.updateSetupModeData,
      isSettingUpNew: isSettingUpNew
    });
  }
  getBottomBar(setupModeState) {
    if (!setupModeState.enabled || setupModeState.hideBottomBar) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xxl"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      "data-test-subj": "monitoringSetupModeBottomBar"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.setupMode.description",
      defaultMessage: "You are in setup mode. The ({flagIcon}) icon indicates configuration options.",
      values: {
        flagIcon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "flag"
        })
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_exit_button.SetupModeExitButton, {
      exitSetupMode: () => (0, _setup_mode.toggleSetupMode)(false)
    })))))));
  }
  async shortcutToFinishMigration() {
    await (0, _setup_mode.disableElasticsearchInternalCollection)();
    await (0, _setup_mode.updateSetupModeData)();
  }
  render() {
    const {
      render,
      productName
    } = this.props;
    const setupModeState = (0, _setup_mode.getSetupModeState)();
    let data = {
      byUuid: {}
    };
    if (setupModeState.data) {
      if (productName && setupModeState.data[productName]) {
        data = setupModeState.data[productName];
      } else if (setupModeState.data) {
        data = setupModeState.data;
      }
    }
    const meta = setupModeState.data ? setupModeState.data._meta : null;
    return render({
      setupMode: {
        data,
        meta,
        enabled: setupModeState.enabled,
        productName,
        updateSetupModeData: _setup_mode.updateSetupModeData,
        shortcutToFinishMigration: () => this.shortcutToFinishMigration(),
        openFlyout: (instance, isSettingUpNew) => this.setState({
          isFlyoutOpen: true,
          instance,
          isSettingUpNew
        }),
        closeFlyout: () => this.setState({
          isFlyoutOpen: false
        })
      },
      flyoutComponent: this.getFlyout(data, meta),
      bottomBarComponent: this.getBottomBar(setupModeState)
    });
  }
}
exports.WrappedSetupModeRenderer = WrappedSetupModeRenderer;
function withErrorHandler(Component) {
  return function WrappedComponent(props) {
    const handleRequestError = (0, _use_request_error_handler.useRequestErrorHandler)();
    return /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
      onHttpError: handleRequestError
    }));
  };
}
WrappedSetupModeRenderer.contextType = _global_state_context.GlobalStateContext;
const SetupModeRenderer = (0, _public.withKibana)(withErrorHandler(WrappedSetupModeRenderer));
exports.SetupModeRenderer = SetupModeRenderer;